/*
 * $Id: TempFileFinalizer.java 12345 2004-08-22 04:56:09Z fielding $
 *
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util;

import java.io.File;

/**
 * Finalizer that works with temporary files in conjunction with
 * a <code>FinalizerHandler</code>
 *
 * @audience core
 * @version $Revision: 1.9 $, $Date: 2004-08-22 06:56:09 +0200 (Sun, 22 Aug 2004) $
 * @author dpfister
 * @since antbear
 */
public final class TempFileFinalizer implements Finalizer {

    /** Temporary file to destroy when this finalizer is called */
    private final File tempFile;

    /**
     * Create a new <code>TempFileFinalizer</code>
     */
    public TempFileFinalizer(File tempFile) {
	this.tempFile = tempFile;
    }

    /**
     * This is the method called by the {@link FinalizerHandler} when the
     * finalizing work has to be done.
     */
    public void doFinalize() {
	tempFile.delete();
    }
}
