/*
 * $URL$
 * $Id$
 *
 * Copyright 1997-2006 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util.diff;

/**
 * Listener that is called for each line in a document.
 * See {@link DocumentDiff#showChanges(ChangeListener, int)} for details.
 *
 * @author tripod
 * @version $Rev$, $Date$
 */
public interface ChangeListener {

    /**
     * The CVS/SVN id
     */
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    /**
     * Invoked before the iteration over the changes start.
     * @param left the left document
     * @param right the right document
     */
    void onDocumentsStart(Document left, Document right);

    /**
     * Invoked after the iteration over the changes finished.
     * @param left the left document
     * @param right the right document
     */
    void onDocumentsEnd(Document left, Document right);

    /**
     * Invoked before a change starts.
     * @param leftElem the index of the left element of this change.
     * @param leftLen the number of changed left elements.
     * @param rightElem the index of the right element of this change.
     * @param rightLen the number of changed right elements.
     */
    void onChangeStart(int leftElem, int leftLen, int rightElem, int rightLen);

    /**
     * Invoked after a change finished.
     */
    void onChangeEnd();

    /**
     * Invoked for an unmodified element
     * @param leftIdx the index of the left element
     * @param rightIdx the index of the right element
     * @param elem the element
     */
    void onUnmodified(int leftIdx, int rightIdx, Document.Element elem);

    /**
     * Invoked for a deleted element
     * @param leftIdx the index of the left element
     * @param rightIdx the index of the right element
     * @param elem the element
     */
    void onDeleted(int leftIdx, int rightIdx, Document.Element elem);

    /**
     * Invoked for an inserted element
     * @param leftIdx the index of the left element
     * @param rightIdx the index of the right element
     * @param elem the element
     */
    void onInserted(int leftIdx, int rightIdx, Document.Element elem);

}
