/*
 * $URL$
 * $Id$
 *
 * Copyright 1997-2006 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util.diff;

/**
 * Provides a default document source
 *
 * @author tripod
 * @version $Rev$, $Date$
 */
public class DefaultDocumentSource implements DocumentSource {

    /**
     * The CVS/SVN id
     */
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    /**
     * some location information
     */
    private final String location;

    /**
     * the author
     */
    private final String author;

    /**
     * the date
     */
    private final long date;

    /**
     * the revision
     */
    private final String revision;

    /**
     * Creates a new default document source
     *
     * @param location some location information
     * @param author the author of the document
     * @param date some date of the document
     * @param revision some revision of the document
     */
    public DefaultDocumentSource(String location, String author, long date, String revision) {
        this.location = location;
        this.author = author;
        this.date = date;
        this.revision = revision;
    }

    /**
     * {@inheritDoc}
     */
    public String getLocation() {
        return location;
    }

    /**
     * Returns the revision information.
     *
     * {@inheritDoc}
     */
    public String getLabel() {
        return revision;
    }

    /**
     * Returns the author
     * @return the author
     */
    public String getAuthor() {
        return author;
    }

    /**
     * Returns the date
     * @return the date
     */
    public long getDate() {
        return date;
    }

    /**
     * Returns the revision
     * @return the revision
     */
    public String getRevision() {
        return revision;
    }


    public String toString() {
        return author + ", " + revision;
    }
}
