/*
 * $URL$
 * $Id$
 *
 * Copyright 1997-2006 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util.diff;

import java.io.Writer;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Implements a writer that provides an additional method {@link #writeNewLine()}
 * that can be used for writing line separators which can be defined. A
 * {@link PrintWriter} would actually be better, but it does not support
 * defining the line separator to use.
 *
 * @author tripod
 * @version $Rev$, $Date$
 */
public class DiffWriter extends Writer {

    /**
     * The CVS/SVN id
     */
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    /**
     * native line separator
     */
    public static final String LS_NATIVE = System.getProperty("line.separator");

    /**
     * unix line separator
     */
    public static final String LS_UNIX = "\n";

    /**
     * windows line separator
     */
    public static final String LS_WINDOWS = "\r\n";

    /**
     * the wrapped writer
      */
    private final Writer out;

    /**
     * the line seperator to use for {@link #writeNewLine()}
     */
    private String lineSeparator = LS_NATIVE;

    /**
     * {@inheritDoc}
     */
    public DiffWriter(Writer out) {
        this.out = out;
    }

    /**
     * {@inheritDoc}
     *
     * @param lineSeparator the line seperator to use for {@link #writeNewLine()}
     */
    public DiffWriter(Writer out, String lineSeparator) {
        this.out = out;
        this.lineSeparator = lineSeparator;
    }

    /**
     * Writes a new line according to the defined line separator
     * @throws IOException if an I/O error occurs
     */
    public void writeNewLine() throws IOException {
        write(lineSeparator);
    }

    /**
     * {@inheritDoc}
     */
    public void write(int c) throws IOException {
        out.write(c);
    }

    /**
     * {@inheritDoc}
     */
    public void write(char[] cbuf) throws IOException {
        out.write(cbuf);
    }

    /**
     * {@inheritDoc}
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        out.write(cbuf, off, len);
    }

    /**
     * {@inheritDoc}
     */
    public void write(String str) throws IOException {
        out.write(str);
    }

    /**
     * {@inheritDoc}
     */
    public void write(String str, int off, int len) throws IOException {
        out.write(str, off, len);
    }

    /**
     * {@inheritDoc}
     */
    public void flush() throws IOException {
        out.flush();
    }

    /**
     * {@inheritDoc}
     */
    public void close() throws IOException {
        out.close();
    }
}