/*
 * $URL$
 * $Id$
 *
 * Copyright 1997-2006 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util.diff;

import java.io.PrintWriter;

/**
 * @author tripod
 * @version $Rev: 26301 $, $Date: 2007-04-26 18:55:18 +0200 (Thu, 26 Apr 2007) $
 */
public class InlineChangeListener implements ChangeListener {

    private final PrintWriter out;

    public InlineChangeListener(PrintWriter out) {
        this.out = out;
    }

    public void onDocumentsStart(Document left, Document right) {
        // ignore
    }

    public void onDocumentsEnd(Document left, Document right) {
        out.flush();
    }

    public void onChangeStart(int leftLine, int leftLen, int rightLine, int rightLen) {
        // ignore
    }

    public void onChangeEnd() {
        out.flush();
    }

    public void onUnmodified(int leftLine, int rightLine, Document.Element text) {
        out.print(text);
    }

    public void onDeleted(int leftLine, int rightLine, Document.Element text) {
        String author = null;
        if (text instanceof Document.AnnotatedElement) {
            Document.AnnotatedElement t = (Document.AnnotatedElement) text;
            if (t.getDocumentSource() instanceof DefaultDocumentSource) {
                DefaultDocumentSource src = (DefaultDocumentSource) t.getDocumentSource();
                author = src.getAuthor();
            }
        }
        out.print("<del");
        if (author != null) {
            out.print(" title=\"");
            out.print(author);
            out.print("\"");
        }
        out.print(">");
        out.print(text);
        out.print("</del>");
    }

    public void onInserted(int leftLine, int rightLine, Document.Element text) {
        String author = null;
        if (text instanceof Document.AnnotatedElement) {
            Document.AnnotatedElement t = (Document.AnnotatedElement) text;
            if (t.getDocumentSource() instanceof DefaultDocumentSource) {
                DefaultDocumentSource src = (DefaultDocumentSource) t.getDocumentSource();
                author = src.getAuthor();
            }
        }
        out.print("<ins");
        if (author != null) {
            out.print(" title=\"");
            out.print(author);
            out.print("\"");
        }
        out.print(">");
        out.print(text);
        out.print("</ins>");
    }
}
