/*
 * $URL$
 * $Id$
 *
 * Copyright 1997-2006 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util.diff;

/**
 * Specifies a range in a document
 *
 * @author tripod
 * @version $Rev$, $Date$
 */
public class Range {

    /**
     * The CVS/SVN id
     */
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    /**
     * the document this range points to
     */
    public final Document doc;

    /**
     * the low line of this range
     */
    public final int low;

    /**
     * the high line of this range. actually points to the line after the one
     * included in this range.
     */
    public final int high;

    /**
     * Creates a new range
     * @param doc the document
     * @param low the low line
     * @param high the high line
     */
    public Range(Document doc, int low, int high) {
        assert low >= 0;
        assert high >= low;
        this.doc = doc;
        this.low = low;
        this.high = high;
    }

    /**
     * Returns the length of this range
     * @return the length.
     */
    public int len() {
        return high - low;
    }

    /**
     * Returns a debug string
     * @return a debug string
     */
    public String toString() {
        return low + "-" + high;
    }

    /**
     * Returns a string suitable for inclusion in a diff output (line number is
     * incremented by one).
     * @return a string for output
     */
    public String toRangeString() {
        if (len() == 1) {
            return String.valueOf(low+1);
        } else {
            return (low + 1) + "," + len();
        }
    }
}