/*
 * $URL$
 * $Id$
 *
 * Copyright 1997-2006 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.util.diff;

import java.io.Reader;
import java.io.StringReader;
import java.io.IOException;
import java.io.BufferedReader;
import java.util.ArrayList;

/**
 * Implements an element factory that creates the elements out from words of
 * the given input stream.
 *
 * @author tripod
 * @version $Rev$, $Date$
 */
public class WordsElementsFactory implements ElementsFactory {

    /**
     * The CVS/SVN id
     */
    static final String CVS_ID = "$URL$ $Rev$ $Date$";

    private static final int MAX_ELEMENTS = 100000;

    private final Document.Element[] elements;

    public WordsElementsFactory(Document.Element[] elements) {
        this.elements = elements;
    }

    public Document.Element[] getElements() {
        return elements;
    }

    public static WordsElementsFactory create(DocumentSource source, String text) {
        try {
            Reader reader = new StringReader(text);
            return create(source, reader);
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public static WordsElementsFactory create(DocumentSource source, Reader text)
            throws IOException {
        Document.Element[] elements = getElements(source, text);
        return new WordsElementsFactory(elements);
    }

    private static Document.Element[] getElements(DocumentSource source, Reader text)
            throws IOException {
        BufferedReader r;
        if (text instanceof BufferedReader) {
            r = (BufferedReader) text;
        } else {
            r = new BufferedReader(text);
        }
        ArrayList lines = new ArrayList();
        StringBuffer gutter = new StringBuffer();
        StringBuffer word = new StringBuffer();
        int c;
        while ((c=r.read()) >=0 && lines.size()<MAX_ELEMENTS) {
            if (Character.isLetterOrDigit((char) c)) {
                if (gutter.length() > 0) {
                    lines.add(new WordElement(source, word.toString(), gutter.toString()));
                    gutter.setLength(0);
                    word.setLength(0);
                }
                word.append((char) c);
            } else {
                gutter.append((char) c);
            }
        }
        if (word.length() > 0) {
            lines.add(new WordElement(source, word.toString(), gutter.toString()));
        }
        return (WordElement[]) lines.toArray(new WordElement[lines.size()]);
    }

    public static class WordElement implements Document.Element {

        private final DocumentSource source;

        private final String word;

        private final String gutter;

        public WordElement(DocumentSource source, String word, String gutter) {
            this.source = source;
            this.word = word;
            this.gutter = gutter;
        }

        public String getString() {
            return word + gutter;
        }

        public DocumentSource getDocumentSource() {
            return source;
        }

        public int hashCode() {
            return word.hashCode();
        }

        public String toString() {
            return getString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WordElement) {
                return ((WordElement) obj).word.equals(word);
            }
            return false;
        }
    }
}
