/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package io.sightly.java.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.script.Bindings;
import javax.script.SimpleBindings;

/**
 * Compiled version of render units.
 * <p>
 * This abstract class was previsouly used as the base class for Sightly
 * templates translated to Java classes. With the move from Sightly to Apache
 * Sling this class is not used any longer. Non-Sightly implementations of this
 * class are ignored.
 *
 * @deprecated as of bundle version 1.1.68 without replacement. Implementations
 *             of this interface are not used and thus ignored by the Sling
 *             Sightly engine.
 */
@Deprecated
public abstract class BaseRenderUnit implements RenderUnit {

    private final Map<String, RenderUnit> subTemplates = new HashMap<String, RenderUnit>();

    private Map<String, RenderUnit> siblings;

    @Override
    public final void render(RenderContext renderContext, Bindings arguments) {
        render(renderContext.getWriter(),
                buildGlobalScope(renderContext.getBindings()),
                new CaseInsensitiveBindings(arguments),
                renderContext.getObjectModel(),
                renderContext.getRuntime(),
                renderContext);
    }

    @Override
    public RenderUnit get(String name) {
        return subTemplates.get(name.toLowerCase());
    }

    @Override
    public Set<String> properties() {
        return subTemplates.keySet();
    }

    protected abstract void render(StackedWriter writer,
                                   Bindings bindings,
                                   Bindings arguments,
                                   ObjectModel dynamic,
                                   SightlyRuntime runtime,
                                   RenderContext renderContext);

    @SuppressWarnings({"unused", "unchecked"})
    protected void callUnit(RenderContext renderContext, Object templateObj, Object argsObj) {
        if (!(templateObj instanceof RenderUnit)) {
            return;
        }
        RenderUnit unit = (RenderUnit) templateObj;
        ObjectModel dynamic = renderContext.getObjectModel();
        Map<String, Object> argumentsMap = dynamic.coerceToMap(argsObj);
        Bindings arguments = new SimpleBindings(Collections.unmodifiableMap(argumentsMap));
        unit.render(renderContext, arguments);
    }

    @SuppressWarnings("UnusedDeclaration")
    protected FluentMap obj() {
        return new FluentMap();
    }

    protected final void addSubTemplate(String name, BaseRenderUnit renderUnit) {
        renderUnit.setSiblings(subTemplates);
        subTemplates.put(name.toLowerCase(), renderUnit);
    }

    private void setSiblings(Map<String, RenderUnit> siblings) {
        this.siblings = siblings;
    }

    private Bindings buildGlobalScope(Bindings bindings) {
        SimpleBindings simpleBindings = new SimpleBindings(bindings);
        simpleBindings.putAll(bindings);
        if (siblings != null) {
            simpleBindings.putAll(siblings);
        }
        simpleBindings.putAll(subTemplates);
        return new CaseInsensitiveBindings(simpleBindings);
    }

    protected static class FluentMap extends HashMap<String, Object> {

        /**
         * Fluent variant of put
         * @param name - the name of the property
         * @param value - the value of the property
         * @return - this instance
         */
        public FluentMap with(String name, Object value) {
            put(name, value);
            return this;
        }

    }

    private static final class CaseInsensitiveBindings extends SimpleBindings {

        private CaseInsensitiveBindings(Map<String, Object> m) {
            for (Map.Entry<String, Object> entry : m.entrySet()) {
                put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }

        @Override
        public Object get(Object key) {
            if (!(key instanceof String)) {
                throw new ClassCastException("key should be a String");
            }
            return super.get(((String) key).toLowerCase());
        }

        @Override
        public boolean containsKey(Object key) {
            if (!(key instanceof String)) {
                throw new ClassCastException("key should be a String");
            }
            return super.containsKey(((String) key).toLowerCase());
        }
    }

}
