/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package io.sightly.java.api;

import java.util.Dictionary;

import org.osgi.service.component.ComponentContext;

/**
 * Component-based implementation for extensions
 *
 * @deprecated as of bundle version 1.1.68. Implement the Sling
 *             {@code org.apache.sling.scripting.sightly.extension.RuntimeExtension}
 *             interface instead setting the
 *             {@code org.apache.sling.scripting.sightly.extension.RuntimeExtension.SCR_PROP_NAME}
 *             service property to define the extension name.
 */
@Deprecated
public abstract class ExtensionComponent implements RuntimeExtension {

    public static final String NAME = "name";

    private String name;

    @Override
    public String name() {
        return name;
    }

    @SuppressWarnings("UnusedDeclaration")
    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        name = (String) properties.get(NAME);
    }

    protected void checkArgumentCount(Object[] arguments, int count) {
        if (arguments.length != count) {
            throw new RuntimeExtensionException(String.format("Extension %s requires %d arguments", name(), count));
        }
    }

    protected void checkArguments(Object[] arguments, Class<?> ... classes) {
        checkArgumentCount(arguments, classes.length);
        for (int i = 0; i < arguments.length; i++) {
            Object arg = arguments[i];
            Class<?> cls = classes[i];
            if (!(cls.isAssignableFrom(arg.getClass()))) {
                throw new RuntimeExtensionException(String.format("Argument on position %d is not of expected type %s",
                        i, cls.getCanonicalName()));
            }
        }
    }
}
