/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package io.sightly.java.api;

import java.util.Collection;
import java.util.Map;

/**
 * Defines the dynamic queries that values must support in Sightly
 *
 * @deprecated as of bundle version 1.1.68 with no direct replacement. Type
 *             conversion methods are implemented by the Sling
 *             {@code RenderContext}. Don't use this interface.
 */
@Deprecated
public interface ObjectModel {

    String PROPERTY_ACCESS = "resolveProperty";
    String COLLECTION_COERCE = "coerceToCollection";
    String NUMERIC_COERCE = "coerceNumeric";
    String STRING_COERCE = "coerceToString";
    String BOOLEAN_COERCE = "coerceToBoolean";

    String STRICT_EQ = "strictEq";
    String LEQ = "leq";
    String LT = "lt";

    /**
     * Retrieve the specified property from the given object
     * @param target - the target object
     * @param property - the property name
     * @return - the value of the property or null if the object has no such property
     */
    Object resolveProperty(Object target, Object property);

    /**
     * Convert the given object to a string.
     * @param target - the target object
     * @return - the string representation of the object
     */
    String coerceToString(Object target);

    /**
     * Convert the given object to a boolean value
     * @param object - the target object
     * @return - the boolean representation of that object
     */
    boolean coerceToBoolean(Object object);

    /**
     * Coerce the object to a numeric value
     * @param object - the target object
     * @return - the numeric representation
     */
    Number coerceNumeric(Object object);

    /**
     * Force the conversion of the object to a collection
     * @param object - the target object
     * @return the collection representation of the object
     */
    Collection<Object> coerceToCollection(Object object);

    /**
     * Force the conversion of the target object to a map
     *
     * @param object - the target object
     * @return - a map representation of the object. Default is an empty map
     */
    Map coerceToMap(Object object);

    /**
     * Check whether the left argument equals the right one
     * @param left the left argument
     * @param right the right argument
     * @return true if arguments are equal
     */
    boolean strictEq(Object left, Object right);

    /**
     * Check if left &lt; right
     * @param left the left argument
     * @param right the right argument
     * @return true if left &lt; right
     */
    boolean lt(Object left, Object right);

    /**
     * Check if left &lt; right
     * @param left the left argument
     * @param right the right argument
     * @return true if left &lt; right
     */
    boolean leq(Object left, Object right);
}
