/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package io.sightly.java.api;


/**
 * Result returned by a use provider
 *
 * @deprecated as of bundle version 1.1.68. Implementations of the Sling
 *             {@code org.apache.sling.scripting.sightly.use.UseProvider}
 *             interface return Sling
 *             {@code org.apache.sling.scripting.sightly.use.ProviderOutcome}
 *             objects.
 */
@Deprecated
public final class ProviderOutcome {

    private boolean success;
    private Object result;

    private static final ProviderOutcome FAILURE = new ProviderOutcome(false, null);

    /**
     * Create a successful outcome
     * @param result the result
     * @return a successful result
     */
    public static ProviderOutcome success(Object result) {
        return new ProviderOutcome(true, result);
    }

    /**
     * Create a failed outcome
     * @return a failed outcome
     */
    public static ProviderOutcome failure() {
        return FAILURE;
    }

    /**
     * If the given obj is not null return a successful outcome, with the given result.
     * Otherwise, return failure
     * @param obj the result
     * @return an outcome based on whether the parameter is null or not
     */
    public static ProviderOutcome notNullOrFailure(Object obj) {
        return (obj == null) ? failure() : success(obj);
    }

    private ProviderOutcome(boolean success, Object result) {
        this.success = success;
        this.result = result;
    }

    /**
     * Check if the outcome has been successful
     * @return the outcome success status
     */
    public boolean isSuccess() {
        return success;
    }

    /**
     * Check whether the outcome is a failure
     * @return the outcome failure status
     */
    public boolean isFailure() {
        return !isSuccess();
    }

    /**
     * Get the result in this outcome
     *
     * @return the result of the container
     * @throws java.lang.UnsupportedOperationException if the outcome is a failure
     */
    public Object getResult() {
        if (!success) {
            throw new UnsupportedOperationException("Outcome has not been successful");
        }
        return result;
    }
}
