/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package io.sightly.java.api;

import io.sightly.java.impl.slingAdapter.ObjectModelAdapter;

import java.util.Map;

import javax.script.Bindings;
import javax.script.SimpleBindings;

/**
 * Rendering context for Sightly rendering units.
 *
 * @see RenderUnit
 * @deprecated as of bundle version 1.1.68. Replaced with Sling
 *             {@code org.apache.sling.scripting.sightly.render.RenderContext}
 *             provided to
 *             {@code org.apache.sling.scripting.sightly.use.UseProvider} and
 *             {@code org.apache.sling.scripting.sightly.extension.RuntimeExtension}
 *             services.
 */
@Deprecated
public class RenderContext {

    private final org.apache.sling.scripting.sightly.render.RenderContext delegatee;
    private final StackedWriter writer;
    private final Bindings bindings;
    private final ObjectModel objectModel;
    private final SightlyRuntime runtime;
    private final UnitLocator unitLocator;

    public RenderContext(final org.apache.sling.scripting.sightly.render.RenderContext delegatee) {
        this.delegatee = delegatee;
        this.writer = null;
        this.bindings = delegatee.getBindings();
        this.objectModel = new ObjectModelAdapter(delegatee);
        this.runtime = null;
        this.unitLocator = null;
    }

    @Deprecated
    public RenderContext(StackedWriter writer, Bindings bindings, ObjectModel objectModel, SightlyRuntime runtime, UnitLocator unitLocator) {
        this.delegatee = null;
        this.writer = writer;
        this.bindings = bindings;
        this.objectModel = objectModel;
        this.runtime = runtime;
        this.unitLocator = unitLocator;
    }

    /**
     * Get the writer where the content should be written
     * @return - a stacked writer
     */
    public StackedWriter getWriter() {
        if (writer == null) {
            throw new SightlyEngineException();
        }
        return writer;
    }

    /**
     * Provide the bindings for this script
     * @return - the list of global bindings available to the script
     */
    public Bindings getBindings() {
        return bindings;
    }

    /**
     * Get an instance of the objectModel object model
     * @return - a objectModel object model instance
     */
    public ObjectModel getObjectModel() {
        return objectModel;
    }

    /**
     * Get the available Sightly runtime
     * @return - an instance of the Sightly runtime
     */
    public SightlyRuntime getRuntime() {
        if (unitLocator == null) {
            throw new SightlyEngineException();
        }
        return runtime;
    }

    /**
     * Get the unit locator
     * @return - a unit locator
     */
    public UnitLocator getUnitLocator() {
        if (unitLocator == null) {
            throw new SightlyEngineException();
        }
        return unitLocator;
    }

    /**
     * Create a new render context with different bindings
     * @param newBindings - the new set of bindings
     * @return - the new render context
     * @deprecated as of bundle version 1.1.68 without replacement. This is an
     *             internal method of the Sightly Implementation.
     */
    @Deprecated
    public RenderContext withBindings(Bindings newBindings) {
        return new RenderContext(this.writer, newBindings, this.objectModel, this.runtime, this.unitLocator);
    }

    /**
     * Create a new render context with additional bindings
     *
     * @param additionalBindings - a dictionary of variables
     * @return - the new render context
     * @deprecated as of bundle version 1.1.68 without replacement. This is an
     *             internal method of the Sightly Implementation.
     */
    @Deprecated
    public RenderContext withAddedBindings(Map additionalBindings) {
        Bindings newBindings = new SimpleBindings();
        newBindings.putAll(this.bindings);
        //noinspection unchecked
        newBindings.putAll(additionalBindings);
        return withBindings(newBindings);
    }
}
