/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2013 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package io.sightly.java.api;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * Utility class which used by the Sightly engine &amp; extensions to resolve
 * resources
 *
 * @deprecated as of bundle version 1.1.68. Use the Sling
 *             {@code org.apache.sling.scripting.sightly.ResourceResolution}
 *             class instead.
 */
@Deprecated
public class ResourceResolution {

    /**
     * Resolve the resource with the given path relative to the base resource, using the
     * resource super type logic
     * @param resourceResolver The resource resolver to be used
     * @param base the base resource. It can be null if path is absolute
     * @param path the path to the resource
     * @return the retrieved resource or null if no resource was found
     * @throws java.lang.UnsupportedOperationException if the resource is not in the resource resolver's search path
     * @throws java.lang.IllegalStateException if the number of steps necessary to search for the resource on the resource
     * superType chain has reached the maximum limit
     * @throws java.lang.IllegalArgumentException if a null componentResource is provided but the path is not absolute
     */
    public static Resource resolveComponentRelative(ResourceResolver resourceResolver, Resource base, String path) {
        return org.apache.sling.scripting.sightly.ResourceResolution.getResourceFromSearchPath(base, path);
    }

    public static Resource resolveComponentForRequest(ResourceResolver resolver, SlingHttpServletRequest request) {
        return org.apache.sling.scripting.sightly.ResourceResolution.getResourceForRequest(resolver, request);
    }
}
