/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/
package io.sightly.java.api;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;

/**
 * Text writing utility which allows stacking of temporary buffers
 *
 * @deprecated as of bundle version 1.1.68 with no replacement. Don't use this
 *             class.
 */
@Deprecated
public class StackedWriter extends Writer {

    private final PrintWriter baseWriter;
    private final Stack<StringWriter> writerStack = new Stack<StringWriter>();
    private PrintWriter current;

    public StackedWriter(PrintWriter baseWriter) {
        this.baseWriter = baseWriter;
        this.current = baseWriter;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        current.write(cbuf, off, len);
    }

    @Override
    public void write(String text) {
        current.write(text);
    }

    @Override
    public void flush() throws IOException {
        current.flush();
    }

    @Override
    public void close() throws IOException {
        if (writerStack.size() != 1) {
            throw new UnsupportedOperationException("Stack is not empty");
        }
        current.close();
    }

    public void push() {
        StringWriter writer = new StringWriter();
        writerStack.push(writer);
        current = new PrintWriter(writer);
    }

    public String pop() {
        String output = null;
        if (!writerStack.isEmpty()) {
            StringWriter writer = writerStack.pop();
            output = writer.toString();
        }
        if (writerStack.isEmpty()) {
            current = baseWriter;
        } else {
            current = new PrintWriter(writerStack.peek());
        }
        return output;
    }
}
