/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package io.sightly.java.api;

import javax.script.Bindings;

/**
 * Provides instances for the use API. Providers are tried in the order
 * of their priority until one is found which can provide a non-null instance
 *
 * @deprecated as of bundle version 1.1.68. Implement the Sling
 *             {@code org.apache.sling.scripting.sightly.use.UseProvider}
 *             interface instead.
 */
public interface UseProvider extends Comparable<UseProvider> {

    int DEFAULT_PRIORITY = 0;

    /**
     * Provide an instance based on the given identifier
     * @param identifier the identifier of the dependency
     * @param renderContext the current rendering context
     * @param arguments Specific arguments provided by the use plugin
     * @return a container with the instance that corresponds to the identifier. If the identifier cannot be
     * handled by this provider, a failed outcome is returned
     */
    ProviderOutcome provide(String identifier, RenderContext renderContext, Bindings arguments);

    /**
     * The priority with which this use provider should be selected. Use 0 if you don't care
     * @return the (possibly negative) priority of this provider
     */
    int priority();

}
