/*******************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package io.sightly.java.api;

import javax.script.Bindings;
import javax.script.SimpleBindings;

import org.apache.felix.scr.annotations.Activate;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;

/**
 * Component-based use provider
 *
 * @deprecated as of bundle version 1.1.68. Implement the Sling
 *             {@code org.apache.sling.scripting.sightly.use.UseProvider}
 *             interface instead using the {@code service.ranking} service
 *             property to define the {@code UseProvider} service order.
 */
public abstract class UseProviderComponent implements UseProvider {

    public static final String PRIORITY = "io.sightly.java.plugin.use.priority";

    private int priority = DEFAULT_PRIORITY;

    @Override
    public int priority() {
        return priority;
    }

    @Override
    public int compareTo(UseProvider o) {
        if (this.priority < o.priority()) {
            return -1;
        } else if (this.priority == o.priority()) {
            return  0;
        }
        return 1;
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        priority = PropertiesUtil.toInteger(componentContext.getProperties().get(PRIORITY), DEFAULT_PRIORITY);
    }

    /**
     * Combine to bindings objects. Priority goes to latter bindings
     * @param former First map of bindings
     * @param latter Second, with greater visibility, map of bindings
     * @return the merging of the two maps
     */
    protected Bindings merge(Bindings former, Bindings latter) {
        Bindings bindings = new SimpleBindings();
        bindings.putAll(former);
        bindings.putAll(latter);
        return bindings;
    }
}
