/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.metadata;

import com.day.cq.dam.commons.metadata.XmpFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Adobe CQ DAM XmpFilter", description="Filtering Xmp Properties by black-/white-listing names and namespaces")
@Service
public class XmpFilterBlackWhite
implements XmpFilter {
    private static final String RDF_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String LN_ALT = "Alt";
    private static final String LN_BAG = "Bag";
    private static final String LN_DESCRIPTION = "Description";
    private static final String LN_LI = "li";
    private static final String LN_RDF = "RDF";
    private static final String LN_SEQ = "Seq";
    private static final QName N_ALT;
    private static final QName N_BAG;
    private static final QName N_DESCRIPTION;
    private static final QName N_LI;
    private static final QName N_RDF;
    private static final QName N_SEQ;
    private static final Set<QName> RdfContainerNames;
    private static final Set<QName> IgnoredPropertyAttributeNames;
    private static final Set<String> IgnoredPropertyAttributeNamespaces;
    private static final XMLResolver DEFAULT_XML_RESOLVER;
    @Property(boolValue={false}, label="Apply Whitelist to XMP Properties", description="Only let the whitelisted xmp properties through, applied before any blacklist")
    public static final String ApplyWhiteList = "xmp.filter.apply_whitelist";
    @Property(value={""}, label="Whitelisted XML Names for XMP filtering", description="XML Names, such as '{namespace-uri}name', '{namespace-uri}*', 'prefix:name' and 'prefix:*', passed on during XMP filtering. Use '[>n]' or '[<n]' to limit the values accepted for multi-valued XMP properties. Example: 'history[<100]' will only let the first 99 values through", cardinality=0x7FFFFFFF)
    public static final String WhiteList = "xmp.filter.whitelist";
    @Property(boolValue={true}, label="Apply Blacklist to XMP Properties", description="Filter out the blacklisted xmp properties, applied after any whitelisting")
    public static final String ApplyBlackList = "xmp.filter.apply_blacklist";
    @Property(value={"{http://ns.adobe.com/photoshop/1.0/}DocumentAncestors[>100]"}, label="Blacklisted XML Names for XMP filtering", description="XML Names, such as '{namespace-uri}name', '{namespace-uri}*', 'prefix:name' and 'prefix:*', filtered out during XMP processing. Use '[>n]' or '[<n]' to limit the values removed for multi-valued XMP properties. Example: 'history[>100]' discards the 101st and following values.", cardinality=0x7FFFFFFF)
    public static final String BlackList = "xmp.filter.blacklist";
    private static final Logger log;
    private EventConditionProvider filterConditions;
    private EventConditionProvider sieveConditions;

    private static NameConditionProvider parseNameList(Object object, boolean bl, XmpFilterMode xmpFilterMode) {
        Object object2 = object;
        return null;
    }

    public XmpFilterBlackWhite() {
        XmpFilterBlackWhite xmpFilterBlackWhite = this;
    }

    public void setConfig(Dictionary dictionary) {
        XmpFilterBlackWhite xmpFilterBlackWhite = this;
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        XmpFilterBlackWhite xmpFilterBlackWhite = this;
    }

    @Override
    public boolean isActive() {
        XmpFilterBlackWhite xmpFilterBlackWhite = this;
        return false;
    }

    @Override
    public InputStream filter(InputStream inputStream) throws IOException {
        XmpFilterBlackWhite xmpFilterBlackWhite = this;
        return null;
    }

    @Override
    public InputStream sieve(InputStream inputStream) throws IOException {
        XmpFilterBlackWhite xmpFilterBlackWhite = this;
        return null;
    }

    private XMLInputFactory getInputFactory() {
        XmpFilterBlackWhite xmpFilterBlackWhite = this;
        return null;
    }

    private XMLOutputFactory getOutputFactory() {
        XmpFilterBlackWhite xmpFilterBlackWhite = this;
        return null;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ Set access$400() {
        return RdfContainerNames;
    }

    static /* synthetic */ QName access$500() {
        return N_LI;
    }

    static /* synthetic */ QName access$600() {
        return N_RDF;
    }

    static /* synthetic */ QName access$700() {
        return N_DESCRIPTION;
    }

    static /* synthetic */ Set access$800() {
        return IgnoredPropertyAttributeNamespaces;
    }

    static /* synthetic */ Set access$900() {
        return IgnoredPropertyAttributeNames;
    }

    static {
        log = LoggerFactory.getLogger(XmpFilterBlackWhite.class);
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$com$day$cq$dam$commons$metadata$XmpFilterBlackWhite$XmpFilterState;
    }

    private static final class StartElementWrapper
    implements StartElement {
        private final StartElement se;
        private final Map<QName, Attribute> attributes;

        StartElementWrapper(StartElement startElement, Set<QName> set) {
            StartElementWrapper startElementWrapper = this;
        }

        @Override
        public QName getName() {
            StartElementWrapper startElementWrapper = this;
            return null;
        }

        public Iterator getAttributes() {
            StartElementWrapper startElementWrapper = this;
            return null;
        }

        public Iterator getNamespaces() {
            StartElementWrapper startElementWrapper = this;
            return null;
        }

        @Override
        public Attribute getAttributeByName(QName qName) {
            StartElementWrapper startElementWrapper = this;
            return null;
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            StartElementWrapper startElementWrapper = this;
            return null;
        }

        @Override
        public String getNamespaceURI(String string) {
            StartElementWrapper startElementWrapper = this;
            return null;
        }

        @Override
        public int getEventType() {
            StartElementWrapper startElementWrapper = this;
            return 0;
        }

        @Override
        public Location getLocation() {
            StartElementWrapper startElementWrapper = this;
            return null;
        }

        @Override
        public boolean isStartElement() {
            StartElementWrapper startElementWrapper = this;
            return false;
        }

        @Override
        public boolean isAttribute() {
            StartElementWrapper startElementWrapper = this;
            return false;
        }

        @Override
        public boolean isNamespace() {
            StartElementWrapper startElementWrapper = this;
            return false;
        }

        @Override
        public boolean isEndElement() {
            StartElementWrapper startElementWrapper = this;
            return false;
        }

        @Override
        public boolean isEntityReference() {
            StartElementWrapper startElementWrapper = this;
            return false;
        }

        @Override
        public boolean isProcessingInstruction() {
            StartElementWrapper startElementWrapper = this;
            return false;
        }

        @Override
        public boolean isCharacters() {
            StartElementWrapper startElementWrapper = this;
            return false;
        }

        @Override
        public boolean isStartDocument() {
            StartElementWrapper startElementWrapper = this;
            return false;
        }

        @Override
        public boolean isEndDocument() {
            StartElementWrapper startElementWrapper = this;
            return false;
        }

        @Override
        public StartElement asStartElement() {
            StartElementWrapper startElementWrapper = this;
            return null;
        }

        @Override
        public EndElement asEndElement() {
            StartElementWrapper startElementWrapper = this;
            return null;
        }

        @Override
        public Characters asCharacters() {
            StartElementWrapper startElementWrapper = this;
            return null;
        }

        @Override
        public QName getSchemaType() {
            StartElementWrapper startElementWrapper = this;
            return null;
        }

        @Override
        public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
            StartElementWrapper startElementWrapper = this;
        }
    }

    private final class ReadableByteArrayOutputStream
    extends ByteArrayOutputStream {
        final /* synthetic */ XmpFilterBlackWhite this$0;

        ReadableByteArrayOutputStream(XmpFilterBlackWhite xmpFilterBlackWhite, int n) {
            ReadableByteArrayOutputStream readableByteArrayOutputStream = this;
        }

        int read(byte[] byArray, int n, int n2) throws IOException {
            ReadableByteArrayOutputStream readableByteArrayOutputStream = this;
            return 0;
        }
    }

    private final class XMLEventReaderInputStream
    extends InputStream {
        final XMLEventWriter writer;
        final XMLEventFilter filter;
        final ReadableByteArrayOutputStream output;
        boolean closed;
        final /* synthetic */ XmpFilterBlackWhite this$0;

        XMLEventReaderInputStream(XmpFilterBlackWhite xmpFilterBlackWhite, XMLEventFilter xMLEventFilter, XMLOutputFactory xMLOutputFactory) throws XMLStreamException {
            XMLEventReaderInputStream xMLEventReaderInputStream = this;
        }

        @Override
        public int available() throws IOException {
            XMLEventReaderInputStream xMLEventReaderInputStream = this;
            return 0;
        }

        @Override
        public void close() throws IOException {
            XMLEventReaderInputStream xMLEventReaderInputStream = this;
        }

        @Override
        public int read() throws IOException {
            XMLEventReaderInputStream xMLEventReaderInputStream = this;
            return 0;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            XMLEventReaderInputStream xMLEventReaderInputStream = this;
            return 0;
        }

        private void prefill(int n) throws IOException {
            XMLEventReaderInputStream xMLEventReaderInputStream = this;
        }
    }

    private class XmpPropFilter
    implements XMLEventFilter {
        private final EventConditionProvider conditions;
        private final XMLEventFilter filter;
        private final List<XMLEvent> nextEvents;
        private XmpFilterState state;
        private QName propName;
        private EventCondition eventCondition;
        private int propDepth;
        private Set<QName> scratchNames;
        final /* synthetic */ XmpFilterBlackWhite this$0;

        XmpPropFilter(XmpFilterBlackWhite xmpFilterBlackWhite, XMLEventFilter xMLEventFilter, EventConditionProvider eventConditionProvider) {
            XmpPropFilter xmpPropFilter = this;
        }

        @Override
        public XMLEvent nextEvent() throws XMLStreamException {
            XmpPropFilter xmpPropFilter = this;
            return null;
        }

        @Override
        public boolean hasNext() throws XMLStreamException {
            XmpPropFilter xmpPropFilter = this;
            return false;
        }

        private void process(XMLEvent xMLEvent) {
            XmpPropFilter xmpPropFilter = this;
        }

        private void filterPropertyAttributesAt(int n) {
            XmpPropFilter xmpPropFilter = this;
        }

        @Override
        public void close() throws XMLStreamException {
            XmpPropFilter xmpPropFilter = this;
        }
    }

    private static class XMLReaderEventFilter
    implements XMLEventFilter {
        private final XMLEventReader reader;
        private XMLEvent nextEvent;

        XMLReaderEventFilter(XMLEventReader xMLEventReader) {
            XMLReaderEventFilter xMLReaderEventFilter = this;
        }

        @Override
        public XMLEvent nextEvent() throws XMLStreamException {
            XMLReaderEventFilter xMLReaderEventFilter = this;
            return null;
        }

        @Override
        public boolean hasNext() throws XMLStreamException {
            XMLReaderEventFilter xMLReaderEventFilter = this;
            return false;
        }

        @Override
        public void close() throws XMLStreamException {
            XMLReaderEventFilter xMLReaderEventFilter = this;
        }
    }

    static interface XMLEventFilter {
        public XMLEvent nextEvent() throws XMLStreamException;

        public boolean hasNext() throws XMLStreamException;

        public void close() throws XMLStreamException;
    }

    private static enum XmpFilterState {
        LOOKING_FOR_RDF,
        LOOKING_FOR_DESCRIPTION,
        LOOKING_FOR_PROP,
        INSIDE_PROP;

    }

    private static class OrConditionProvider
    implements EventConditionProvider {
        final EventConditionProvider cond1;
        final EventConditionProvider cond2;
        final Map<QName, EventCondition> env;

        OrConditionProvider(EventConditionProvider eventConditionProvider, EventConditionProvider eventConditionProvider2, XmpFilterMode xmpFilterMode) {
            OrConditionProvider orConditionProvider = this;
        }

        @Override
        public EventCondition getCondition(QName qName) {
            OrConditionProvider orConditionProvider = this;
            return null;
        }

        @Override
        public boolean isEmpty() {
            OrConditionProvider orConditionProvider = this;
            return false;
        }

        @Override
        public EventConditionProvider newInstance(XmpFilterMode xmpFilterMode) {
            OrConditionProvider orConditionProvider = this;
            return null;
        }
    }

    private static class AndConditionProvider
    implements EventConditionProvider {
        final EventConditionProvider cond1;
        final EventConditionProvider cond2;
        final Map<QName, EventCondition> env;

        AndConditionProvider(EventConditionProvider eventConditionProvider, EventConditionProvider eventConditionProvider2, XmpFilterMode xmpFilterMode) {
            AndConditionProvider andConditionProvider = this;
        }

        @Override
        public EventCondition getCondition(QName qName) {
            AndConditionProvider andConditionProvider = this;
            return null;
        }

        @Override
        public boolean isEmpty() {
            AndConditionProvider andConditionProvider = this;
            return false;
        }

        @Override
        public EventConditionProvider newInstance(XmpFilterMode xmpFilterMode) {
            AndConditionProvider andConditionProvider = this;
            return null;
        }
    }

    private static class NameConditionProvider
    implements EventConditionProvider {
        private final Set<String> namespaces;
        private final Map<String, Set<String>> names;
        private final Set<String> prefixes;
        private final Map<String, Set<String>> prefixedNames;
        private final Map<Object, EventCondition> conditions;
        private final boolean exclude;
        private final XmpFilterMode mode;
        Map<Object, EventCondition> env;

        NameConditionProvider(Set<String> set, Map<String, Set<String>> map, Set<String> set2, Map<String, Set<String>> map2, Map<Object, EventCondition> map3, boolean bl, XmpFilterMode xmpFilterMode) {
            NameConditionProvider nameConditionProvider = this;
        }

        NameConditionProvider(NameConditionProvider nameConditionProvider, boolean bl, XmpFilterMode xmpFilterMode) {
            NameConditionProvider nameConditionProvider2 = this;
        }

        @Override
        public EventCondition getCondition(QName qName) {
            NameConditionProvider nameConditionProvider = this;
            return null;
        }

        @Override
        public boolean isEmpty() {
            NameConditionProvider nameConditionProvider = this;
            return false;
        }

        @Override
        public EventConditionProvider newInstance(XmpFilterMode xmpFilterMode) {
            NameConditionProvider nameConditionProvider = this;
            return null;
        }

        private Object getConditionToken(QName qName) {
            NameConditionProvider nameConditionProvider = this;
            return null;
        }

        private EventCondition getDefinedCondition(Object object, QName qName) {
            NameConditionProvider nameConditionProvider = this;
            return null;
        }
    }

    static interface EventConditionProvider {
        public EventCondition getCondition(QName var1);

        public boolean isEmpty();

        public EventConditionProvider newInstance(XmpFilterMode var1);
    }

    private static class MinIndexCondition
    implements EventCondition {
        private final int minIndex;
        private int count;
        private int level;
        private int ignoreLevel;
        private int containerLevel;

        MinIndexCondition(int n) {
            MinIndexCondition minIndexCondition = this;
        }

        @Override
        public boolean acceptsValue(String string) {
            MinIndexCondition minIndexCondition = this;
            return false;
        }

        @Override
        public boolean accepts(XMLEvent xMLEvent, List<XMLEvent> list) {
            MinIndexCondition minIndexCondition = this;
            return false;
        }

        @Override
        public EventCondition newInstance(boolean bl, XmpFilterMode xmpFilterMode) {
            MinIndexCondition minIndexCondition = this;
            return null;
        }
    }

    private static class MaxIndexCondition
    implements EventCondition {
        private final int maxIndex;
        private int count;
        private int level;
        private int ignoreLevel;
        private int containerLevel;

        MaxIndexCondition(int n) {
            MaxIndexCondition maxIndexCondition = this;
        }

        @Override
        public boolean acceptsValue(String string) {
            MaxIndexCondition maxIndexCondition = this;
            return false;
        }

        @Override
        public boolean accepts(XMLEvent xMLEvent, List<XMLEvent> list) {
            MaxIndexCondition maxIndexCondition = this;
            return false;
        }

        @Override
        public EventCondition newInstance(boolean bl, XmpFilterMode xmpFilterMode) {
            MaxIndexCondition maxIndexCondition = this;
            return null;
        }
    }

    private static class OrCondition
    implements EventCondition {
        private final EventCondition cond1;
        private final EventCondition cond2;

        OrCondition(EventCondition eventCondition, EventCondition eventCondition2) {
            OrCondition orCondition = this;
        }

        @Override
        public boolean acceptsValue(String string) {
            OrCondition orCondition = this;
            return false;
        }

        @Override
        public boolean accepts(XMLEvent xMLEvent, List<XMLEvent> list) {
            OrCondition orCondition = this;
            return false;
        }

        @Override
        public EventCondition newInstance(boolean bl, XmpFilterMode xmpFilterMode) {
            OrCondition orCondition = this;
            return null;
        }
    }

    private static class AndCondition
    implements EventCondition {
        private final EventCondition cond1;
        private final EventCondition cond2;

        AndCondition(EventCondition eventCondition, EventCondition eventCondition2) {
            AndCondition andCondition = this;
        }

        @Override
        public boolean acceptsValue(String string) {
            AndCondition andCondition = this;
            return false;
        }

        @Override
        public boolean accepts(XMLEvent xMLEvent, List<XMLEvent> list) {
            AndCondition andCondition = this;
            return false;
        }

        @Override
        public EventCondition newInstance(boolean bl, XmpFilterMode xmpFilterMode) {
            AndCondition andCondition = this;
            return null;
        }
    }

    private static class DenyCondition
    implements EventCondition {
        private DenyCondition() {
            DenyCondition denyCondition = this;
        }

        @Override
        public boolean accepts(XMLEvent xMLEvent, List<XMLEvent> list) {
            DenyCondition denyCondition = this;
            return false;
        }

        @Override
        public boolean acceptsValue(String string) {
            DenyCondition denyCondition = this;
            return false;
        }

        @Override
        public EventCondition newInstance(boolean bl, XmpFilterMode xmpFilterMode) {
            DenyCondition denyCondition = this;
            return null;
        }
    }

    private static class AcceptCondition
    implements EventCondition {
        private AcceptCondition() {
            AcceptCondition acceptCondition = this;
        }

        @Override
        public boolean accepts(XMLEvent xMLEvent, List<XMLEvent> list) {
            AcceptCondition acceptCondition = this;
            return false;
        }

        @Override
        public boolean acceptsValue(String string) {
            AcceptCondition acceptCondition = this;
            return false;
        }

        @Override
        public EventCondition newInstance(boolean bl, XmpFilterMode xmpFilterMode) {
            AcceptCondition acceptCondition = this;
            return null;
        }
    }

    static interface EventCondition {
        public static final EventCondition ACCEPT;
        public static final EventCondition DENY;

        public boolean acceptsValue(String var1);

        public boolean accepts(XMLEvent var1, List<XMLEvent> var2);

        public EventCondition newInstance(boolean var1, XmpFilterMode var2);
    }

    private static enum XmpFilterMode {
        FILTER,
        SIEVE;

    }

    private static class NameDef {
        private static final Pattern RE_LIMIT_MAX;
        String orig;
        String uri;
        String localName;
        String prefix;
        EventCondition condition;
        Object condToken;

        private NameDef() {
            NameDef nameDef = this;
        }

        void init(String string) {
            NameDef nameDef = this;
        }
    }
}

