/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.jmx;

import aQute.bnd.annotation.ProviderType;
import com.adobe.granite.jmx.annotation.Description;
import com.adobe.granite.jmx.annotation.Impact;
import com.adobe.granite.jmx.annotation.Name;
import com.adobe.granite.jmx.annotation.OpenTypeInfo;
import com.day.crx.sling.server.jmx.ClusterNodeInfoTabular;
import com.day.crx.sling.server.jmx.SimpleMap;
import javax.jcr.RepositoryException;
import javax.management.openmbean.TabularData;

@Description(value="CRX Repository")
@ProviderType
public interface ManagedRepositoryMBean {
    @Description(value="The name of the repository")
    public String getName();

    @Description(value="The version of the repository")
    public String getVersion();

    @Description(value="The name of the customer the repository is licensed to")
    public String getCustomerName();

    public String getLicenseKey();

    public String getHomeDir();

    public Long getAvailableDiskSpace();

    public Integer getMaximumNumberOfOpenFiles();

    public Boolean getSessionTracker();

    public void setSessionTracker(Boolean var1);

    @OpenTypeInfo(value=SimpleMap.class)
    @Description(value="The repository descriptors")
    public TabularData getDescriptors();

    @Description(value="The workspaces currently available in the repository")
    public String[] getWorkspaceNames();

    @Impact(value=1)
    @Description(value="Create a new workspace with the give name.")
    public void createWorkspace(@Name(value="name") @Description(value="The name of the new workspace") String var1) throws RepositoryException;

    @Description(value="Number of milliseconds to sleep after each ten nodes scanned")
    public Integer getDataStoreGarbageCollectionDelay();

    public void setDataStoreGarbageCollectionDelay(Integer var1);

    @Impact(value=1)
    @Description(value="Runs data store garbage collection")
    public void runDataStoreGarbageCollection(@Name(value="delete") @Description(value="Flag to delete all collected garbage") Boolean var1) throws RepositoryException;

    @Description(value="Is a data store garbage collection currently in progress?")
    public Boolean getDataStoreGarbageCollectionInProgress();

    @Impact(value=1)
    @Description(value="Initiates a revision garbage collection operation")
    public void startRevisionGC();

    @Description(value="Is a revision garbage collection currently in progress?")
    public Boolean getRevisionGCInProgress();

    @Description(value="The extra delay (in milliseconds) added between steps of the backup process")
    public Integer getBackupDelay();

    public void setBackupDelay(Integer var1);

    @Description(value="Is a backup currently in progress?")
    public Boolean getBackupInProgress();

    @Description(value="Progress of the currently running backup process")
    public Integer getBackupProgress();

    @Description(value="The path of the currently running backup process")
    public String getCurrentBackupTarget();

    @Description(value="Was the last backup successful?")
    public Boolean getBackupWasSuccessful();

    @Description(value="The status message of the last backup")
    public String getBackupResult();

    @Impact(value=1)
    @Description(value="Creates a backup of this instance, including the repository, the application code and configuration")
    public void startBackup(@Name(value="target") @Description(value="Optional target directory or file (with .zip extension)") String var1) throws RepositoryException;

    @Impact(value=1)
    @Description(value="Creates a backup of this instance, including the repository, the application code and configuration")
    public void startBackup(@Name(value="repositoryDir") @Description(value="Optional CRX repository directory") String var1, @Name(value="target") @Description(value="Optional target directory or file (with .zip extension)") String var2) throws RepositoryException;

    @Impact(value=1)
    @Description(value="Cancels the current backup process")
    public void cancelBackup();

    @Impact(value=1)
    @Description(value="Blocks all repository writes")
    public void blockRepositoryWrites() throws RepositoryException;

    @Impact(value=1)
    @Description(value="Unblocks all repository writes")
    public void unblockRepositoryWrites() throws RepositoryException;

    @Description(value="The timestamp of when Tar PM optimization was started, or 0 if it's currently not running")
    public Long getTarOptimizationRunningSince();

    @Description(value="Number of milliseconds to sleep after optimizing one transaction")
    public Integer getTarOptimizationDelay();

    public void setTarOptimizationDelay(Integer var1);

    @Impact(value=1)
    @Description(value="Start Tar PM optimization")
    public void startTarOptimization() throws RepositoryException;

    @Impact(value=1)
    @Description(value="Stop Tar PM optimization")
    public void stopTarOptimization() throws RepositoryException;

    @Impact(value=1)
    @Description(value="Tar PM index merge may improve the Tar PM performance")
    public void tarIndexMerge(@Name(value="background") @Description(value="Merge in the background") Boolean var1) throws RepositoryException;

    @OpenTypeInfo(value=SimpleMap.class)
    @Description(value="Cluster properties")
    public TabularData getClusterProperties();

    @OpenTypeInfo(value=ClusterNodeInfoTabular.class)
    @Description(value="The identifiers and hostnames of all cluster nodes")
    public TabularData getClusterNodes();

    @Description(value="Identifier of this cluster")
    public String getClusterId();

    @Description(value="Identifier of the master node")
    public String getClusterMasterId();

    @Description(value="Identifier of this cluster node")
    public String getClusterNodeId();

    @Description(value="The instance revision of this cluster node")
    public Long getClusterNodeRevision();

    @Impact(value=1)
    @Description(value="Turns this node into the master of the cluster")
    public void becomeClusterMaster() throws RepositoryException;

    @Impact(value=1)
    @Description(value="Turns this repository into a slave of the given cluster")
    public void joinCluster(@Name(value="master") @Description(value="URL of the cluster master") String var1, @Name(value="username") @Description(value="Username of a cluster administrator") String var2, @Name(value="password") @Description(value="Password of a cluster administrator") String var3) throws Exception;

    @Impact(value=1)
    @Description(value="Traverses the structure of the repository")
    public String traversalCheck(@Name(value="rootNode") @Description(value="The start path") String var1, @Name(value="logEach") @Description(value="Log each node") Boolean var2, @Name(value="fixInconsistencies") @Description(value="Fixes inconsistencies automatically") Boolean var3);

    @Impact(value=1)
    @Description(value="Finds inconsistent nodes")
    public String consistencyCheck(@Name(value="rootNode") @Description(value="The start path") String var1, @Name(value="fixInconsistencies") @Description(value="Fixes inconsistencies automatically") Boolean var2);

    @Impact(value=1)
    @Description(value="Creates a new checkpoint of the latest root of the tree.")
    public String checkpoint(@Name(value="lifetime") @Description(value="lifetime time (in milliseconds, > 0) that the checkpoint should remain available") Long var1);
}

