/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.CMYKColorSpace;
import com.twelvemonkeys.imageio.color.ICCProfileSanitizer;
import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.lang.Platform;
import com.twelvemonkeys.lang.SystemUtil;
import com.twelvemonkeys.lang.Validate;
import com.twelvemonkeys.util.LRUHashMap;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;

public final class ColorSpaces {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.color.debug"));
    private static final ICCProfileSanitizer profileCleaner = ICCProfileSanitizer.Factory.get();
    public static final int CS_ADOBE_RGB_1998 = 5000;
    public static final int CS_GENERIC_CMYK = 5001;
    private static WeakReference<ICC_Profile> adobeRGB1998 = new WeakReference<Object>(null);
    private static WeakReference<ICC_Profile> genericCMYK = new WeakReference<Object>(null);
    private static final Map<Key, ICC_ColorSpace> cache = new LRUHashMap(10);

    private ColorSpaces() {
    }

    public static ICC_ColorSpace createColorSpace(ICC_Profile profile) {
        Validate.notNull((Object)profile, (String)"profile");
        byte[] profileHeader = profile.getData(1751474532);
        ICC_ColorSpace cs = ColorSpaces.getInternalCS(profile.getColorSpaceType(), profileHeader);
        if (cs != null) {
            return cs;
        }
        if (profileHeader[64] != 0) {
            profileHeader[64] = 0;
            cs = ColorSpaces.getInternalCS(profile.getColorSpaceType(), profileHeader);
            if (cs != null) {
                return cs;
            }
            profileCleaner.fixProfile(profile, profileHeader);
        } else {
            profileCleaner.fixProfile(profile, null);
        }
        return ColorSpaces.getCachedOrCreateCS(profile, profileHeader);
    }

    private static ICC_ColorSpace getInternalCS(int profileCSType, byte[] profileHeader) {
        if (profileCSType == 5 && Arrays.equals(profileHeader, sRGB.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1000);
        }
        if (profileCSType == 6 && Arrays.equals(profileHeader, GRAY.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1003);
        }
        if (profileCSType == 13 && Arrays.equals(profileHeader, PYCC.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1002);
        }
        if (profileCSType == 5 && Arrays.equals(profileHeader, LINEAR_RGB.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1004);
        }
        if (profileCSType == 0 && Arrays.equals(profileHeader, CIEXYZ.header)) {
            return (ICC_ColorSpace)ColorSpace.getInstance(1001);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ICC_ColorSpace getCachedOrCreateCS(ICC_Profile profile, byte[] profileHeader) {
        Key key = new Key(profileHeader);
        Map<Key, ICC_ColorSpace> map = cache;
        synchronized (map) {
            ICC_ColorSpace cs = cache.get(key);
            if (cs == null) {
                cs = new ICC_ColorSpace(profile);
                cs.fromRGB(new float[]{1.0f, 0.0f, 0.0f});
                cache.put(key, cs);
            }
            return cs;
        }
    }

    public static boolean isCS_sRGB(ICC_Profile profile) {
        Validate.notNull((Object)profile, (String)"profile");
        return profile.getColorSpaceType() == 5 && Arrays.equals(profile.getData(1751474532), sRGB.header);
    }

    static boolean isOffendingColorProfile(ICC_Profile profile) {
        Validate.notNull((Object)profile, (String)"profile");
        byte[] data = profile.getData(1751474532);
        return data[64] != 0;
    }

    public static ICC_Profile validateProfile(ICC_Profile profile) {
        ColorSpaces.createColorSpace(profile);
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorSpace getColorSpace(int colorSpace) {
        switch (colorSpace) {
            case 5000: {
                Class<ColorSpaces> clazz = ColorSpaces.class;
                synchronized (ColorSpaces.class) {
                    ICC_Profile profile = (ICC_Profile)adobeRGB1998.get();
                    if (profile == null) {
                        profile = ColorSpaces.readProfileFromPath(Profiles.getPath("ADOBE_RGB_1998"));
                        if (profile == null && (profile = ColorSpaces.readProfileFromClasspathResource("/profiles/ClayRGB1998.icc")) == null) {
                            throw new IllegalStateException("Could not read AdobeRGB1998 profile");
                        }
                        adobeRGB1998 = new WeakReference<ICC_Profile>(profile);
                    }
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    return ColorSpaces.createColorSpace(profile);
                }
            }
            case 5001: {
                Class<ColorSpaces> clazz = ColorSpaces.class;
                synchronized (ColorSpaces.class) {
                    ICC_Profile profile = (ICC_Profile)genericCMYK.get();
                    if (profile == null) {
                        profile = ColorSpaces.readProfileFromPath(Profiles.getPath("GENERIC_CMYK"));
                        if (profile == null) {
                            if (DEBUG) {
                                System.out.println("Using fallback profile");
                            }
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return CMYKColorSpace.getInstance();
                        }
                        genericCMYK = new WeakReference<ICC_Profile>(profile);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return ColorSpaces.createColorSpace(profile);
                }
            }
        }
        return ColorSpace.getInstance(colorSpace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ICC_Profile readProfileFromClasspathResource(String profilePath) {
        InputStream stream = ColorSpaces.class.getResourceAsStream(profilePath);
        if (stream != null) {
            if (DEBUG) {
                System.out.println("Loading profile from classpath resource: " + profilePath);
            }
            try {
                ICC_Profile iCC_Profile = ICC_Profile.getInstance(stream);
                return iCC_Profile;
            }
            catch (IOException ignore) {
                if (DEBUG) {
                    ignore.printStackTrace();
                }
            }
            finally {
                FileUtil.close((InputStream)stream);
            }
        }
        return null;
    }

    private static ICC_Profile readProfileFromPath(String profilePath) {
        block6: {
            if (profilePath != null) {
                if (DEBUG) {
                    System.out.println("Loading profile from: " + profilePath);
                }
                try {
                    return ICC_Profile.getInstance(profilePath);
                }
                catch (SecurityException ignore) {
                    if (DEBUG) {
                        ignore.printStackTrace();
                    }
                }
                catch (IOException ignore) {
                    if (!DEBUG) break block6;
                    ignore.printStackTrace();
                }
            }
        }
        return null;
    }

    private static class Profiles {
        private static final Properties PROFILES = Profiles.loadProfiles();

        private Profiles() {
        }

        private static Properties loadProfiles() {
            Properties systemDefaults;
            try {
                systemDefaults = SystemUtil.loadProperties(ColorSpaces.class, (String)("com/twelvemonkeys/imageio/color/icc_profiles_" + Platform.os().id()));
            }
            catch (SecurityException ignore) {
                System.err.printf("Warning: Could not load system default ICC profile locations from %s, will use bundled fallback profiles.\n", ignore.getMessage());
                if (DEBUG) {
                    ignore.printStackTrace();
                }
                systemDefaults = null;
            }
            catch (IOException ignore) {
                System.err.printf("Warning: Could not load system default ICC profile locations from %s, will use bundled fallback profiles.\n", ignore.getMessage());
                if (DEBUG) {
                    ignore.printStackTrace();
                }
                systemDefaults = null;
            }
            Properties profiles = new Properties(systemDefaults);
            try {
                Properties userOverrides = SystemUtil.loadProperties(ColorSpaces.class, (String)"com/twelvemonkeys/imageio/color/icc_profiles");
                profiles.putAll((Map<?, ?>)userOverrides);
            }
            catch (SecurityException ignore) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (DEBUG) {
                System.out.println("User ICC profiles: " + profiles);
                System.out.println("System ICC profiles : " + systemDefaults);
            }
            return profiles;
        }

        public static String getPath(String profileName) {
            return PROFILES.getProperty(profileName);
        }
    }

    private static class LINEAR_RGB {
        private static final byte[] header = ICC_Profile.getInstance(1004).getData(1751474532);

        private LINEAR_RGB() {
        }
    }

    private static class GRAY {
        private static final byte[] header = ICC_Profile.getInstance(1003).getData(1751474532);

        private GRAY() {
        }
    }

    private static class PYCC {
        private static final byte[] header = ICC_Profile.getInstance(1002).getData(1751474532);

        private PYCC() {
        }
    }

    private static class CIEXYZ {
        private static final byte[] header = ICC_Profile.getInstance(1001).getData(1751474532);

        private CIEXYZ() {
        }
    }

    private static class sRGB {
        private static final byte[] header = ICC_Profile.getInstance(1000).getData(1751474532);

        private sRGB() {
        }
    }

    private static final class Key {
        private final byte[] data;

        public Key(byte[] data) {
            this.data = data;
        }

        public boolean equals(Object other) {
            return other instanceof Key && Arrays.equals(this.data, ((Key)other).data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }
}

