/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.imageio.color.ICCProfileSanitizer;
import com.twelvemonkeys.lang.Validate;
import java.awt.color.ICC_Profile;
import java.util.Arrays;

final class KCMSSanitizerStrategy
implements ICCProfileSanitizer {
    private static final byte[] CORBIS_RGB_ALTERNATE_XYZ = new byte[]{23, -91, 5, -72};

    KCMSSanitizerStrategy() {
    }

    @Override
    public void fixProfile(ICC_Profile profile, byte[] profileHeader) {
        Validate.notNull((Object)profile, (String)"profile");
        if (profileHeader != null) {
            profile.setData(1751474532, profileHeader);
        }
        if (KCMSSanitizerStrategy.fixProfileXYZTag(profile, 0x77747074)) {
            KCMSSanitizerStrategy.fixProfileXYZTag(profile, 1918392666);
            KCMSSanitizerStrategy.fixProfileXYZTag(profile, 1733843290);
            KCMSSanitizerStrategy.fixProfileXYZTag(profile, 1649957210);
        }
    }

    private static boolean fixProfileXYZTag(ICC_Profile profile, int tagSignature) {
        byte[] data = profile.getData(tagSignature);
        if (data != null && Arrays.equals(Arrays.copyOfRange(data, 0, 4), CORBIS_RGB_ALTERNATE_XYZ)) {
            data[0] = 88;
            data[1] = 89;
            data[2] = 90;
            data[3] = 32;
            profile.setData(tagSignature, data);
            return true;
        }
        return false;
    }
}

