/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata;

import com.twelvemonkeys.imageio.metadata.AbstractDirectory;
import com.twelvemonkeys.imageio.metadata.CompoundDirectory;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.lang.Validate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractCompoundDirectory
extends AbstractDirectory
implements CompoundDirectory {
    private final List<Directory> directories = new ArrayList<Directory>();

    protected AbstractCompoundDirectory(Collection<? extends Directory> directories) {
        super(null);
        if (directories != null) {
            this.directories.addAll(Validate.noNullElements(directories));
        }
    }

    @Override
    public Directory getDirectory(int index) {
        return this.directories.get(index);
    }

    @Override
    public int directoryCount() {
        return this.directories.size();
    }

    @Override
    public Entry getEntryById(Object identifier) {
        for (Directory directory : this.directories) {
            Entry entry = directory.getEntryById(identifier);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Entry getEntryByFieldName(String fieldName) {
        for (Directory directory : this.directories) {
            Entry entry = directory.getEntryByFieldName(fieldName);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Iterator<Entry> iterator() {
        return new Iterator<Entry>(){
            Iterator<Directory> directoryIterator;
            Iterator<Entry> current;
            {
                this.directoryIterator = AbstractCompoundDirectory.this.directories.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.current != null && this.current.hasNext() || this.directoryIterator.hasNext() && (this.current = this.directoryIterator.next().iterator()).hasNext();
            }

            @Override
            public Entry next() {
                this.hasNext();
                return this.current.next();
            }

            @Override
            public void remove() {
                this.current.remove();
            }
        };
    }

    @Override
    public boolean add(Entry entry) {
        throw new UnsupportedOperationException("Directory is read-only");
    }

    @Override
    public boolean remove(Object entry) {
        throw new UnsupportedOperationException("Directory is read-only");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public int size() {
        int size = 0;
        for (Directory directory : this.directories) {
            size += directory.size();
        }
        return size;
    }

    @Override
    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.directories.toString());
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (Directory ifd : this.directories) {
            hash ^= ifd.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object pOther) {
        if (pOther == this) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther.getClass() != this.getClass()) {
            return false;
        }
        CompoundDirectory other = (CompoundDirectory)pOther;
        if (this.directoryCount() != other.directoryCount()) {
            return false;
        }
        for (int i = 0; i < this.directoryCount(); ++i) {
            if (this.getDirectory(i).equals(other.getDirectory(i))) continue;
            return false;
        }
        return true;
    }
}

