/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.lang.Validate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractDirectory
implements Directory {
    private final List<Entry> entries = new ArrayList<Entry>();
    private final List<Entry> unmodifiable = Collections.unmodifiableList(this.entries);

    protected AbstractDirectory(Collection<? extends Entry> entries) {
        if (entries != null) {
            this.entries.addAll(Validate.noNullElements(entries));
        }
    }

    @Override
    public Entry getEntryById(Object identifier) {
        for (Entry entry : this) {
            if (!entry.getIdentifier().equals(identifier)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Entry getEntryByFieldName(String fieldName) {
        for (Entry entry : this) {
            if (entry.getFieldName() == null || !entry.getFieldName().equals(fieldName)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.isReadOnly() ? this.unmodifiable.iterator() : this.entries.iterator();
    }

    protected final void assertMutable() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Directory is read-only");
        }
    }

    @Override
    public boolean add(Entry entry) {
        this.assertMutable();
        return this.entries.add(entry);
    }

    @Override
    public boolean remove(Object entry) {
        this.assertMutable();
        return this.entries.remove(entry);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null || this.getClass() != pOther.getClass()) {
            return false;
        }
        AbstractDirectory other = (AbstractDirectory)pOther;
        return this.entries.equals(other.entries);
    }

    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.entries.toString());
    }
}

