/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.exif;

import com.twelvemonkeys.imageio.metadata.CompoundDirectory;
import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.MetadataReader;
import com.twelvemonkeys.imageio.metadata.exif.EXIFDirectory;
import com.twelvemonkeys.imageio.metadata.exif.EXIFEntry;
import com.twelvemonkeys.imageio.metadata.exif.IFD;
import com.twelvemonkeys.imageio.metadata.exif.Rational;
import com.twelvemonkeys.imageio.metadata.exif.TIFF;
import com.twelvemonkeys.imageio.metadata.exif.Unknown;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.lang.Validate;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public final class EXIFReader
extends MetadataReader {
    static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.imageio.metadata.exif.debug"));
    static final Collection<Integer> KNOWN_IFDS = Collections.unmodifiableCollection(Arrays.asList(34665, 34853, 40965, 330));

    @Override
    public Directory read(ImageInputStream input) throws IOException {
        Validate.notNull((Object)input, (String)"input");
        byte[] bom = new byte[2];
        input.readFully(bom);
        if (bom[0] == 73 && bom[1] == 73) {
            input.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else if (bom[0] == 77 && bom[1] == 77) {
            input.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else {
            throw new IIOException(String.format("Invalid TIFF byte order mark '%s', expected: 'II' or 'MM'", StringUtil.decode((byte[])bom, (int)0, (int)bom.length, (String)"ASCII")));
        }
        int magic = input.readUnsignedShort();
        if (magic != 42) {
            throw new IIOException(String.format("Wrong TIFF magic in EXIF data: %04x, expected: %04x", magic, 42));
        }
        long directoryOffset = input.readUnsignedInt();
        return this.readDirectory(input, directoryOffset, true);
    }

    protected Directory readDirectory(ImageInputStream pInput, long pOffset, boolean readLinked) throws IOException {
        int entryCount;
        ArrayList<IFD> ifds = new ArrayList<IFD>();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        pInput.seek(pOffset);
        long nextOffset = -1L;
        try {
            entryCount = pInput.readUnsignedShort();
        }
        catch (EOFException e) {
            entryCount = 0;
        }
        for (int i = 0; i < entryCount; ++i) {
            EXIFEntry entry = this.readEntry(pInput);
            if (entry == null) {
                nextOffset = 0L;
                break;
            }
            entries.add(entry);
        }
        if (readLinked) {
            if (nextOffset == -1L) {
                nextOffset = pInput.readUnsignedInt();
            }
            if (nextOffset != 0L) {
                CompoundDirectory next = (CompoundDirectory)this.readDirectory(pInput, nextOffset, true);
                for (int i = 0; i < next.directoryCount(); ++i) {
                    ifds.add((IFD)next.getDirectory(i));
                }
            }
        }
        this.readSubdirectories(pInput, entries, Arrays.asList(34665, 34853, 40965, 330));
        ifds.add(0, new IFD(entries));
        return new EXIFDirectory((Collection<? extends Directory>)ifds);
    }

    private void readSubdirectories(ImageInputStream input, List<Entry> entries, List<Integer> subIFDIds) throws IOException {
        if (subIFDIds == null || subIFDIds.isEmpty()) {
            return;
        }
        int entriesSize = entries.size();
        for (int i = 0; i < entriesSize; ++i) {
            EXIFEntry entry = (EXIFEntry)entries.get(i);
            int tagId = (Integer)entry.getIdentifier();
            if (!subIFDIds.contains(tagId)) continue;
            try {
                if (!KNOWN_IFDS.contains(tagId)) continue;
                long[] pointerOffsets = this.getPointerOffsets(entry);
                ArrayList<IFD> subIFDs = new ArrayList<IFD>(pointerOffsets.length);
                for (long pointerOffset : pointerOffsets) {
                    CompoundDirectory subDirectory = (CompoundDirectory)this.readDirectory(input, pointerOffset, false);
                    for (int j = 0; j < subDirectory.directoryCount(); ++j) {
                        subIFDs.add((IFD)subDirectory.getDirectory(j));
                    }
                }
                if (subIFDs.size() == 1) {
                    entries.set(i, new EXIFEntry(tagId, subIFDs.get(0), entry.getType()));
                    continue;
                }
                entries.set(i, new EXIFEntry(tagId, subIFDs.toArray(new IFD[subIFDs.size()]), entry.getType()));
                continue;
            }
            catch (IIOException e) {
                e.printStackTrace();
            }
        }
    }

    private long[] getPointerOffsets(Entry entry) throws IIOException {
        long[] offsets;
        Object value = entry.getValue();
        if (value instanceof Byte) {
            offsets = new long[]{(Byte)value & 0xFF};
        } else if (value instanceof Short) {
            offsets = new long[]{(Short)value & 0xFFFF};
        } else if (value instanceof Integer) {
            offsets = new long[]{(long)((Integer)value).intValue() & 0xFFFFFFFFL};
        } else if (value instanceof Long) {
            offsets = new long[]{(Long)value};
        } else if (value instanceof long[]) {
            offsets = (long[])value;
        } else {
            throw new IIOException(String.format("Unknown pointer type: %s", value != null ? value.getClass() : null));
        }
        return offsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EXIFEntry readEntry(ImageInputStream pInput) throws IOException {
        Object value;
        int tagId = pInput.readUnsignedShort();
        short type = pInput.readShort();
        if (tagId == 0 && type == 0) {
            return null;
        }
        int count = pInput.readInt();
        if (count < 0) {
            throw new IIOException(String.format("Illegal count %d for tag %s type %s @%08x", count, tagId, type, pInput.getStreamPosition()));
        }
        if (type <= 0 || type > 13) {
            long offset = pInput.getStreamPosition() - 8L;
            if (DEBUG) {
                System.err.printf("Bad EXIF data @%08x\n", pInput.getStreamPosition());
                System.err.println("tagId: " + tagId + (tagId <= 0 ? " (INVALID)" : ""));
                System.err.println("type: " + type + " (INVALID)");
                System.err.println("count: " + count);
            }
            pInput.mark();
            pInput.seek(offset);
            try {
                byte[] bytes = new byte[8 + Math.min(120, Math.max(24, count))];
                int len = pInput.read(bytes);
                if (DEBUG) {
                    System.err.print(HexDump.dump(offset, bytes, 0, len));
                    System.err.println(len < count ? "[...]" : "");
                }
            }
            finally {
                pInput.reset();
            }
            return null;
        }
        int valueLength = EXIFReader.getValueLength(type, count);
        if (valueLength > 0 && valueLength <= 4) {
            value = this.readValueInLine(pInput, type, count);
            pInput.skipBytes(4 - valueLength);
        } else {
            long valueOffset = pInput.readUnsignedInt();
            value = this.readValueAt(pInput, valueOffset, type, count);
        }
        return new EXIFEntry(tagId, value, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readValueAt(ImageInputStream pInput, long pOffset, short pType, int pCount) throws IOException {
        long pos = pInput.getStreamPosition();
        try {
            pInput.seek(pOffset);
            Object object = EXIFReader.readValue(pInput, pType, pCount);
            return object;
        }
        finally {
            pInput.seek(pos);
        }
    }

    private Object readValueInLine(ImageInputStream pInput, short pType, int pCount) throws IOException {
        return EXIFReader.readValue(pInput, pType, pCount);
    }

    private static Object readValue(ImageInputStream pInput, short pType, int pCount) throws IOException {
        long pos = pInput.getStreamPosition();
        switch (pType) {
            case 2: {
                if (pCount == 0) {
                    return "";
                }
                byte[] ascii = new byte[pCount];
                pInput.readFully(ascii);
                int len = ascii[ascii.length - 1] == 0 ? ascii.length - 1 : ascii.length;
                return StringUtil.decode((byte[])ascii, (int)0, (int)len, (String)"UTF-8");
            }
            case 1: {
                if (pCount == 1) {
                    return pInput.readUnsignedByte();
                }
            }
            case 6: {
                if (pCount == 1) {
                    return pInput.readByte();
                }
            }
            case 7: {
                byte[] bytes = new byte[pCount];
                pInput.readFully(bytes);
                return bytes;
            }
            case 3: {
                if (pCount == 1) {
                    return pInput.readUnsignedShort();
                }
            }
            case 8: {
                if (pCount == 1) {
                    return pInput.readShort();
                }
                short[] shorts = new short[pCount];
                pInput.readFully(shorts, 0, shorts.length);
                if (pType == 3) {
                    int[] ints = new int[pCount];
                    for (int i = 0; i < pCount; ++i) {
                        ints[i] = shorts[i] & 0xFFFF;
                    }
                    return ints;
                }
                return shorts;
            }
            case 4: 
            case 13: {
                if (pCount == 1) {
                    return pInput.readUnsignedInt();
                }
            }
            case 9: {
                if (pCount == 1) {
                    return pInput.readInt();
                }
                int[] ints = new int[pCount];
                pInput.readFully(ints, 0, ints.length);
                if (pType == 4 || pType == 13) {
                    long[] longs = new long[pCount];
                    for (int i = 0; i < pCount; ++i) {
                        longs[i] = (long)ints[i] & 0xFFFFFFFFL;
                    }
                    return longs;
                }
                return ints;
            }
            case 11: {
                if (pCount == 1) {
                    return Float.valueOf(pInput.readFloat());
                }
                float[] floats = new float[pCount];
                pInput.readFully(floats, 0, floats.length);
                return floats;
            }
            case 12: {
                if (pCount == 1) {
                    return pInput.readDouble();
                }
                double[] doubles = new double[pCount];
                pInput.readFully(doubles, 0, doubles.length);
                return doubles;
            }
            case 5: {
                if (pCount == 1) {
                    return EXIFReader.createSafeRational(pInput.readUnsignedInt(), pInput.readUnsignedInt());
                }
                Rational[] rationals = new Rational[pCount];
                for (int i = 0; i < rationals.length; ++i) {
                    rationals[i] = EXIFReader.createSafeRational(pInput.readUnsignedInt(), pInput.readUnsignedInt());
                }
                return rationals;
            }
            case 10: {
                if (pCount == 1) {
                    return EXIFReader.createSafeRational(pInput.readInt(), pInput.readInt());
                }
                Rational[] srationals = new Rational[pCount];
                for (int i = 0; i < srationals.length; ++i) {
                    srationals[i] = EXIFReader.createSafeRational(pInput.readInt(), pInput.readInt());
                }
                return srationals;
            }
            case 16: 
            case 17: 
            case 18: {
                if (pCount == 1) {
                    long val = pInput.readLong();
                    if (pType != 17 && val < 0L) {
                        throw new IIOException(String.format("Value > %s", Long.MAX_VALUE));
                    }
                    return val;
                }
                long[] longs = new long[pCount];
                for (int i = 0; i < pCount; ++i) {
                    longs[i] = pInput.readLong();
                }
                return longs;
            }
        }
        return new Unknown(pType, pCount, pos);
    }

    private static Rational createSafeRational(long numerator, long denominator) throws IOException {
        if (denominator == 0L) {
            return Rational.NaN;
        }
        return new Rational(numerator, denominator);
    }

    static int getValueLength(int pType, int pCount) {
        if (pType > 0 && pType <= TIFF.TYPE_LENGTHS.length) {
            return TIFF.TYPE_LENGTHS[pType - 1] * pCount;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        EXIFReader reader = new EXIFReader();
        ImageInputStream stream = ImageIO.createImageInputStream(new File(args[0]));
        long pos = 0L;
        if (args.length > 1) {
            pos = args[1].startsWith("0x") ? (long)Integer.parseInt(args[1].substring(2), 16) : Long.parseLong(args[1]);
            stream.setByteOrder(pos < 0L ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            pos = Math.abs(pos);
            stream.seek(pos);
        }
        try {
            Directory directory = args.length > 1 ? reader.readDirectory(stream, pos, false) : reader.read(stream);
            for (Entry entry : directory) {
                System.err.println(entry);
                Object value = entry.getValue();
                if (!(value instanceof byte[])) continue;
                byte[] bytes = (byte[])value;
                System.err.println(HexDump.dump(0L, bytes, 0, Math.min(bytes.length, 128)));
            }
        }
        finally {
            stream.close();
        }
    }

    public static class HexDump {
        private static final int WIDTH = 32;

        private HexDump() {
        }

        public static String dump(byte[] bytes) {
            return HexDump.dump(0L, bytes, 0, bytes.length);
        }

        public static String dump(long offset, byte[] bytes, int off, int len) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i % 32 == 0) {
                    if (i > 0) {
                        builder.append("\n");
                    }
                    builder.append(String.format("%08x: ", (long)(i + off) + offset));
                } else if (i > 0 && i % 2 == 0) {
                    builder.append(" ");
                }
                builder.append(String.format("%02x", bytes[i + off]));
                int next = i + 1;
                if (next % 32 != 0 && next != len) continue;
                int leftOver = (32 - next % 32) % 32;
                if (leftOver != 0) {
                    int pad = leftOver / 2;
                    if (len % 2 != 0) {
                        builder.append("  ");
                    }
                    for (int j = 0; j < pad; ++j) {
                        builder.append("     ");
                    }
                }
                builder.append("  ");
                builder.append(HexDump.toAsciiString(bytes, next - (32 - leftOver) + off, next + off));
            }
            return builder.toString();
        }

        private static String toAsciiString(byte[] bytes, int from, int to) {
            byte[] range = Arrays.copyOfRange(bytes, from, to);
            for (int i = 0; i < range.length; ++i) {
                if (range[i] >= 32 && range[i] <= 126) continue;
                range[i] = 46;
            }
            return new String(range, Charset.forName("ascii"));
        }
    }
}

