/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.iptc;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.MetadataReader;
import com.twelvemonkeys.imageio.metadata.iptc.IPTCDirectory;
import com.twelvemonkeys.imageio.metadata.iptc.IPTCEntry;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

public final class IPTCReader
extends MetadataReader {
    private static final int ENCODING_UNKNOWN = -1;
    private static final int ENCODING_UNSPECIFIED = 0;
    private static final int ENCODING_UTF_8 = 1779015;
    private int encoding = 0;

    @Override
    public Directory read(ImageInputStream input) throws IOException {
        Validate.notNull((Object)input, (String)"input");
        ArrayList<IPTCEntry> entries = new ArrayList<IPTCEntry>();
        while (input.read() == 28) {
            int tagByteCount;
            short tagId = input.readShort();
            IPTCEntry entry = this.readEntry(input, tagId, tagByteCount = input.readUnsignedShort());
            if (entry == null) continue;
            entries.add(entry);
        }
        return new IPTCDirectory(entries);
    }

    private IPTCEntry readEntry(ImageInputStream pInput, short pTagId, int pLength) throws IOException {
        Object value = null;
        switch (pTagId) {
            case 346: {
                this.encoding = this.parseEncoding(pInput, pLength);
                return null;
            }
            case 512: {
                value = pInput.readUnsignedShort();
                break;
            }
            default: {
                if ((pTagId & 0xFF00) == 512) break;
                pInput.skipBytes(pLength);
                return null;
            }
        }
        if (value == null) {
            value = pLength < 1 ? null : this.parseString(pInput, pLength);
        }
        return new IPTCEntry(pTagId, value);
    }

    private int parseEncoding(ImageInputStream pInput, int tagByteCount) throws IOException {
        return tagByteCount == 3 && (pInput.readUnsignedByte() << 16 | pInput.readUnsignedByte() << 8 | pInput.readUnsignedByte()) == 1779015 ? 1779015 : -1;
    }

    private String parseString(ImageInputStream pInput, int pLength) throws IOException {
        byte[] data = new byte[pLength];
        pInput.readFully(data);
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder decoder = charset.newDecoder();
        try {
            CharBuffer chars = decoder.onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(data));
            return chars.toString();
        }
        catch (CharacterCodingException notUTF8) {
            if (this.encoding == 1779015) {
                throw new IIOException("Wrong encoding of IPTC data, explicitly set to UTF-8 in DataSet 1:90", notUTF8);
            }
            return StringUtil.decode((byte[])data, (int)0, (int)data.length, (String)"ISO8859_1");
        }
    }
}

