/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.psd;

import com.twelvemonkeys.imageio.metadata.AbstractEntry;
import com.twelvemonkeys.imageio.metadata.psd.PSD;
import com.twelvemonkeys.lang.StringUtil;
import java.lang.reflect.Field;

class PSDEntry
extends AbstractEntry {
    private final String name;

    public PSDEntry(int resourceId, String name, Object value) {
        super(resourceId, value);
        this.name = StringUtil.isEmpty((String)name) ? null : name;
    }

    @Override
    protected String getNativeIdentifier() {
        return String.format("0x%04x", (Integer)this.getIdentifier());
    }

    @Override
    public String getFieldName() {
        Class[] classes;
        block2: for (Class cl : classes = new Class[]{this.getPSDClass()}) {
            Field[] fields;
            for (Field field : fields = cl.getDeclaredFields()) {
                try {
                    if (field.getType() != Integer.TYPE || !field.getName().startsWith("RES_")) continue;
                    field.setAccessible(true);
                    if (!field.get(null).equals(this.getIdentifier())) continue;
                    return StringUtil.lispToCamel((String)field.getName().substring(4).replace("_", "-").toLowerCase(), (boolean)true);
                }
                catch (IllegalAccessException e) {
                    continue block2;
                }
            }
        }
        return this.name;
    }

    private Class<?> getPSDClass() {
        try {
            return Class.forName("com.twelvemonkeys.imageio.plugins.psd.PSD");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return PSD.class;
        }
    }
}

