/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.xmp;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.Entry;
import com.twelvemonkeys.imageio.metadata.MetadataReader;
import com.twelvemonkeys.imageio.metadata.xmp.RDFDescription;
import com.twelvemonkeys.imageio.metadata.xmp.XMP;
import com.twelvemonkeys.imageio.metadata.xmp.XMPDirectory;
import com.twelvemonkeys.imageio.metadata.xmp.XMPEntry;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMPReader
extends MetadataReader {
    @Override
    public Directory read(ImageInputStream input) throws IOException {
        Validate.notNull((Object)input, (String)"input");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(IIOUtil.createStreamAdapter(input)));
            String toolkit = this.getToolkit(document);
            Node rdfRoot = document.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF").item(0);
            NodeList descriptions = document.getElementsByTagNameNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
            return this.parseDirectories(rdfRoot, descriptions, toolkit);
        }
        catch (SAXException e) {
            throw new IIOException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private String getToolkit(Document document) {
        NodeList xmpmeta = document.getElementsByTagNameNS("adobe:ns:meta/", "xmpmeta");
        if (xmpmeta == null || xmpmeta.getLength() <= 0) {
            return null;
        }
        Node toolkit = xmpmeta.item(0).getAttributes().getNamedItemNS("adobe:ns:meta/", "xmptk");
        return toolkit != null ? toolkit.getNodeValue() : null;
    }

    private XMPDirectory parseDirectories(Node pParentNode, NodeList pNodes, String toolkit) {
        LinkedHashMap<String, List<Entry>> subdirs = new LinkedHashMap<String, List<Entry>>();
        for (Node node : this.asIterable(pNodes)) {
            if (node.getParentNode() != pParentNode) continue;
            this.parseAttributesForKnownElements(subdirs, node);
            for (Node node2 : this.asIterable(node.getChildNodes())) {
                Object value;
                if (node2.getNodeType() != 1) continue;
                ArrayList<XMPEntry> dir = (ArrayList<XMPEntry>)subdirs.get(node2.getNamespaceURI());
                if (dir == null) {
                    dir = new ArrayList<XMPEntry>();
                    subdirs.put(node2.getNamespaceURI(), dir);
                }
                if (this.isResourceType(node2)) {
                    value = this.parseAsResource(node2);
                } else {
                    LinkedHashMap<String, List<Entry>> subsubdirs = new LinkedHashMap<String, List<Entry>>();
                    this.parseAttributesForKnownElements(subsubdirs, node2);
                    if (!subsubdirs.isEmpty()) {
                        ArrayList entries = new ArrayList();
                        for (Map.Entry entry : subsubdirs.entrySet()) {
                            entries.addAll((Collection)entry.getValue());
                        }
                        value = new RDFDescription(entries);
                    } else {
                        value = this.getChildTextValue(node2);
                    }
                }
                dir.add(new XMPEntry(node2.getNamespaceURI() + node2.getLocalName(), node2.getLocalName(), value));
            }
        }
        ArrayList<RDFDescription> entries = new ArrayList<RDFDescription>();
        for (Map.Entry entry : subdirs.entrySet()) {
            entries.add(new RDFDescription((String)entry.getKey(), (Collection)entry.getValue()));
        }
        return new XMPDirectory(entries, toolkit);
    }

    private boolean isResourceType(Node node) {
        Node parseType = node.getAttributes().getNamedItemNS("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType");
        return parseType != null && "Resource".equals(parseType.getNodeValue());
    }

    private RDFDescription parseAsResource(Node node) {
        ArrayList<XMPEntry> entries = new ArrayList<XMPEntry>();
        for (Node node2 : this.asIterable(node.getChildNodes())) {
            if (node2.getNodeType() != 1) continue;
            entries.add(new XMPEntry(node2.getNamespaceURI() + node2.getLocalName(), node2.getLocalName(), this.getChildTextValue(node2)));
        }
        return new RDFDescription(entries);
    }

    private void parseAttributesForKnownElements(Map<String, List<Entry>> subdirs, Node desc) {
        NamedNodeMap attributes = desc.getAttributes();
        for (Node node : this.asIterable(attributes)) {
            if (!XMP.ELEMENTS.contains(node.getNamespaceURI())) continue;
            List<Entry> dir = subdirs.get(node.getNamespaceURI());
            if (dir == null) {
                dir = new ArrayList<Entry>();
                subdirs.put(node.getNamespaceURI(), dir);
            }
            dir.add(new XMPEntry(node.getNamespaceURI() + node.getLocalName(), node.getLocalName(), node.getNodeValue()));
        }
    }

    private Object getChildTextValue(Node node) {
        for (Node node2 : this.asIterable(node.getChildNodes())) {
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(node2.getNamespaceURI()) && "Alt".equals(node2.getLocalName())) {
                LinkedHashMap<String, Object> alternatives = new LinkedHashMap<String, Object>();
                for (Node node3 : this.asIterable(node2.getChildNodes())) {
                    if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(node3.getNamespaceURI()) || !"li".equals(node3.getLocalName())) continue;
                    NamedNodeMap attributes = node3.getAttributes();
                    Node key = attributes.getNamedItem("xml:lang");
                    alternatives.put(key == null ? null : key.getTextContent(), this.getChildTextValue(node3));
                }
                return alternatives;
            }
            if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(node2.getNamespaceURI()) || !"Seq".equals(node2.getLocalName()) && !"Bag".equals(node2.getLocalName())) continue;
            ArrayList<Object> seq = new ArrayList<Object>();
            for (Node node4 : this.asIterable(node2.getChildNodes())) {
                if (!"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(node4.getNamespaceURI()) || !"li".equals(node4.getLocalName())) continue;
                Object value = this.getChildTextValue(node4);
                seq.add(value);
            }
            return Collections.unmodifiableList(seq);
        }
        if (this.isResourceType(node)) {
            return this.parseAsResource(node);
        }
        Node child = node.getFirstChild();
        String string = child != null ? child.getNodeValue() : null;
        return string != null ? string.trim() : "";
    }

    private Iterable<? extends Node> asIterable(final NamedNodeMap pNodeList) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    private int index;

                    @Override
                    public boolean hasNext() {
                        return pNodeList != null && pNodeList.getLength() > this.index;
                    }

                    @Override
                    public Node next() {
                        return pNodeList.item(this.index++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Method remove not supported");
                    }
                };
            }
        };
    }

    private Iterable<? extends Node> asIterable(final NodeList pNodeList) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    private int index;

                    @Override
                    public boolean hasNext() {
                        return pNodeList != null && pNodeList.getLength() > this.index;
                    }

                    @Override
                    public Node next() {
                        return pNodeList.item(this.index++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Method remove not supported");
                    }
                };
            }
        };
    }
}

