/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.util;

import com.twelvemonkeys.imageio.util.IndexedImageTypeSpecifier;
import com.twelvemonkeys.imageio.util.UInt32ImageTypeSpecifier;
import java.awt.color.ColorSpace;
import java.awt.image.IndexColorModel;
import javax.imageio.ImageTypeSpecifier;

public final class ImageTypeSpecifiers {
    private ImageTypeSpecifiers() {
    }

    public static ImageTypeSpecifier createFromBufferedImageType(int bufferedImageType) {
        return ImageTypeSpecifier.createFromBufferedImageType(bufferedImageType);
    }

    public static ImageTypeSpecifier createPacked(ColorSpace colorSpace, int redMask, int greenMask, int blueMask, int alphaMask, int transferType, boolean isAlphaPremultiplied) {
        return ImageTypeSpecifier.createPacked(colorSpace, redMask, greenMask, blueMask, alphaMask, transferType, isAlphaPremultiplied);
    }

    public static ImageTypeSpecifier createInterleaved(ColorSpace colorSpace, int[] bandOffsets, int dataType, boolean hasAlpha, boolean isAlphaPremultiplied) {
        if (dataType == 3) {
            return new UInt32ImageTypeSpecifier(colorSpace, bandOffsets, hasAlpha, isAlphaPremultiplied);
        }
        return ImageTypeSpecifier.createInterleaved(colorSpace, bandOffsets, dataType, hasAlpha, isAlphaPremultiplied);
    }

    public static ImageTypeSpecifier createBanded(ColorSpace colorSpace, int[] bankIndices, int[] bandOffsets, int dataType, boolean hasAlpha, boolean isAlphaPremultiplied) {
        return ImageTypeSpecifier.createBanded(colorSpace, bankIndices, bandOffsets, dataType, hasAlpha, isAlphaPremultiplied);
    }

    public static ImageTypeSpecifier createGrayscale(int bits, int dataType) {
        if (bits == 32 && dataType == 3) {
            return new UInt32ImageTypeSpecifier(ColorSpace.getInstance(1003), new int[]{0}, false, false);
        }
        return ImageTypeSpecifier.createGrayscale(bits, dataType, false);
    }

    public static ImageTypeSpecifier createGrayscale(int bits, int dataType, boolean isAlphaPremultiplied) {
        if (bits == 32 && dataType == 3) {
            return new UInt32ImageTypeSpecifier(ColorSpace.getInstance(1003), new int[]{0, 1}, true, isAlphaPremultiplied);
        }
        return ImageTypeSpecifier.createGrayscale(bits, dataType, false, isAlphaPremultiplied);
    }

    public static ImageTypeSpecifier createIndexed(byte[] redLUT, byte[] greenLUT, byte[] blueLUT, byte[] alphaLUT, int bits, int dataType) {
        return ImageTypeSpecifier.createIndexed(redLUT, greenLUT, blueLUT, alphaLUT, bits, dataType);
    }

    public static ImageTypeSpecifier createIndexed(int[] colors, boolean hasAlpha, int transIndex, int bits, int dataType) {
        return ImageTypeSpecifiers.createFromIndexColorModel(new IndexColorModel(bits, colors.length, colors, 0, hasAlpha, transIndex, dataType));
    }

    public static ImageTypeSpecifier createFromIndexColorModel(IndexColorModel pColorModel) {
        return new IndexedImageTypeSpecifier(pColorModel);
    }
}

