/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.sort;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public abstract class EscapeUtils {
    public static String escapeLineBreak(@Nullable String line) {
        if (line == null) {
            return null;
        }
        if (EscapeUtils.escapingRequired(line)) {
            line = EscapeUtils.escape(line);
        }
        return line;
    }

    public static String unescapeLineBreaks(@Nullable String line) {
        if (line == null) {
            return null;
        }
        if (EscapeUtils.unescapingRequired(line)) {
            line = EscapeUtils.unescape(line);
        }
        return line;
    }

    private static boolean escapingRequired(String line) {
        int len = line.length();
        for (int i = 0; i < len; ++i) {
            char c = line.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': 
                case '\\': {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean unescapingRequired(String line) {
        return line.indexOf(92) >= 0;
    }

    private static String escape(String line) {
        int len = line.length();
        StringBuilder sb = new StringBuilder(len + 1);
        block5: for (int i = 0; i < len; ++i) {
            char c = line.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block5;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static String unescape(String line) {
        int len = line.length();
        StringBuilder sb = new StringBuilder(len - 1);
        for (int i = 0; i < len; ++i) {
            char c = line.charAt(i);
            if (c == '\\') {
                Preconditions.checkState(i < len - 1, "Expected one more char after '\\' at [%s] in [%s]", i, line);
                char nextChar = line.charAt(i + 1);
                switch (nextChar) {
                    case 'n': {
                        sb.append('\n');
                        ++i;
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        ++i;
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        ++i;
                        break;
                    }
                    default: {
                        String msg = String.format("Unexpected char [%c] found at %d of [%s]. Expected '\\' or 'r' or 'n", Character.valueOf(nextChar), i, line);
                        throw new IllegalArgumentException(msg);
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

