/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.json;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.jcr.PropertyType;

public final class TypeCodes {
    public static final String EMPTY_ARRAY = "[0]:";
    private static final Map<Integer, String> TYPE2CODE = new HashMap<Integer, String>();
    private static final Map<String, Integer> CODE2TYPE = new HashMap<String, Integer>();

    private TypeCodes() {
    }

    public static String encode(int propertyType, String propertyName) {
        String typeCode = Preconditions.checkNotNull(TYPE2CODE.get(propertyType));
        return typeCode + ':' + propertyName;
    }

    public static int split(String jsonString) {
        if (jsonString.startsWith(":blobId:")) {
            return 7;
        }
        if (jsonString.length() >= 4 && jsonString.charAt(3) == ':') {
            return 3;
        }
        return -1;
    }

    public static int decodeType(int split, String jsonString) {
        if (split == -1 || split > jsonString.length()) {
            return 0;
        }
        Integer type = CODE2TYPE.get(jsonString.substring(0, split));
        return type == null ? 0 : type;
    }

    public static String decodeName(int split, String jsonString) {
        if (split == -1 || split >= jsonString.length()) {
            return jsonString;
        }
        return jsonString.substring(split + 1);
    }

    static {
        for (int type = 0; type <= 12; ++type) {
            String code = type == 2 ? ":blobId" : PropertyType.nameFromValue((int)type).substring(0, 3).toLowerCase(Locale.ENGLISH);
            TYPE2CODE.put(type, code);
            CODE2TYPE.put(code, type);
        }
    }
}

