/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.namepath;

import org.apache.jackrabbit.oak.namepath.JcrNameParser;

public final class JcrPathParser {
    private static final int STATE_PREFIX_START = 0;
    private static final int STATE_PREFIX = 1;
    private static final int STATE_NAME_START = 2;
    private static final int STATE_NAME = 3;
    private static final int STATE_INDEX = 4;
    private static final int STATE_INDEX_END = 5;
    private static final int STATE_DOT = 6;
    private static final int STATE_DOTDOT = 7;
    private static final int STATE_URI = 8;
    private static final int STATE_URI_END = 9;
    private static final char EOF = '\uffff';

    private JcrPathParser() {
    }

    public static boolean parse(String jcrPath, Listener listener) {
        int len;
        int n = len = jcrPath == null ? 0 : jcrPath.length();
        if (len == 1 && jcrPath.charAt(0) == '/') {
            listener.root();
            return true;
        }
        if (len == 0) {
            return true;
        }
        int pos = 0;
        if (jcrPath.charAt(0) == '/') {
            if (!listener.root()) {
                return false;
            }
            ++pos;
        }
        int state = 0;
        int lastPos = pos;
        String name = null;
        int index = 0;
        boolean wasSlash = false;
        while (pos <= len) {
            char c = pos == len ? (char)'\uffff' : (char)jcrPath.charAt(pos);
            ++pos;
            switch (c) {
                case '/': 
                case '\uffff': {
                    if (state == 0 && c != '\uffff') {
                        listener.error('\'' + jcrPath + "' is not a valid path. " + "double slash '//' not allowed.");
                        return false;
                    }
                    if (state == 1 || state == 3 || state == 5 || state == 9) {
                        if (name == null) {
                            if (wasSlash) {
                                listener.error('\'' + jcrPath + "' is not a valid path: " + "Trailing slashes not allowed in prefixes and names.");
                                return false;
                            }
                            name = jcrPath.substring(lastPos, pos - 1);
                        }
                        if (!JcrNameParser.parse(name, listener, index)) {
                            return false;
                        }
                        state = 0;
                        lastPos = pos;
                        name = null;
                        index = 0;
                        break;
                    }
                    if (state == 6) {
                        if (!listener.current()) {
                            return false;
                        }
                        lastPos = pos;
                        state = 0;
                        break;
                    }
                    if (state == 7) {
                        if (!listener.parent()) {
                            return false;
                        }
                        lastPos = pos;
                        state = 0;
                        break;
                    }
                    if (state != 8 && (state != 0 || c != '\uffff')) {
                        listener.error('\'' + jcrPath + "' is not a valid path. '" + c + "' not a valid name character.");
                        return false;
                    }
                    if (state != 8 || c != 65535) break;
                    listener.error('\'' + jcrPath + "' is not a valid path. Missing '}'.");
                    return false;
                }
                case '.': {
                    if (state == 0) {
                        state = 6;
                        break;
                    }
                    if (state == 6) {
                        state = 7;
                        break;
                    }
                    if (state == 7) {
                        state = 1;
                        break;
                    }
                    if (state != 5) break;
                    listener.error('\'' + jcrPath + "' is not a valid path. '" + c + "' not valid after index. '/' expected.");
                    return false;
                }
                case ':': {
                    if (state == 0) {
                        listener.error('\'' + jcrPath + "' is not a valid path. Prefix " + "must not be empty");
                        return false;
                    }
                    if (state == 1) {
                        if (wasSlash) {
                            listener.error('\'' + jcrPath + "' is not a valid path: " + "Trailing slashes not allowed in prefixes and names.");
                            return false;
                        }
                        state = 2;
                        break;
                    }
                    if (state == 8) break;
                    listener.error('\'' + jcrPath + "' is not a valid path. '" + c + "' not valid name character");
                    return false;
                }
                case '[': {
                    if (state != 1 && state != 3) break;
                    if (wasSlash) {
                        listener.error('\'' + jcrPath + "' is not a valid path: " + "Trailing slashes not allowed in prefixes and names.");
                        return false;
                    }
                    state = 4;
                    name = jcrPath.substring(lastPos, pos - 1);
                    lastPos = pos;
                    break;
                }
                case ']': {
                    if (state == 4) {
                        try {
                            index = Integer.parseInt(jcrPath.substring(lastPos, pos - 1));
                        }
                        catch (NumberFormatException e) {
                            listener.error('\'' + jcrPath + "' is not a valid path. " + "NumberFormatException in index: " + jcrPath.substring(lastPos, pos - 1));
                            return false;
                        }
                        if (index < 0) {
                            listener.error('\'' + jcrPath + "' is not a valid path. " + "Index number invalid: " + index);
                            return false;
                        }
                        state = 5;
                        break;
                    }
                    listener.error('\'' + jcrPath + "' is not a valid path. '" + c + "' not a valid name character.");
                    return false;
                }
                case '*': 
                case '|': {
                    listener.error('\'' + jcrPath + "' is not a valid path. '" + c + "' not a valid name character.");
                    return false;
                }
                case '{': {
                    if (state == 0 && lastPos == pos - 1) {
                        state = 8;
                        break;
                    }
                    if (state != 2 && state != 6 && state != 7) break;
                    state = 3;
                    break;
                }
                case '}': {
                    if (state != 8) break;
                    state = 9;
                    break;
                }
                default: {
                    if (state == 0 || state == 6 || state == 7) {
                        state = 1;
                        break;
                    }
                    if (state == 2) {
                        state = 3;
                        break;
                    }
                    if (state != 5) break;
                    listener.error('\'' + jcrPath + "' is not a valid path. '" + c + "' not valid after index. '/' expected.");
                    return false;
                }
            }
            wasSlash = c == '/';
        }
        return true;
    }

    public static boolean validate(String jcrPath) {
        Listener listener = new Listener(){
            int depth;
            boolean hasRoot;

            @Override
            public boolean root() {
                if (this.hasRoot) {
                    return false;
                }
                this.hasRoot = true;
                return true;
            }

            @Override
            public boolean current() {
                return true;
            }

            @Override
            public boolean parent() {
                --this.depth;
                return !this.hasRoot || this.depth >= 0;
            }

            @Override
            public void error(String message) {
            }

            @Override
            public boolean name(String name, int index) {
                ++this.depth;
                return true;
            }
        };
        return JcrPathParser.parse(jcrPath, listener);
    }

    static interface Listener
    extends JcrNameParser.Listener {
        public boolean root();

        public boolean current();

        public boolean parent();
    }
}

