/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.namepath;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.JcrPathParser;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamePathMapperImpl
implements NamePathMapper {
    private static final Logger log = LoggerFactory.getLogger(NamePathMapperImpl.class);
    private final NameMapper nameMapper;
    private final IdentifierManager idManager;

    public NamePathMapperImpl(NameMapper nameMapper) {
        this.nameMapper = nameMapper;
        this.idManager = null;
    }

    public NamePathMapperImpl(NameMapper nameMapper, IdentifierManager idManager) {
        this.nameMapper = nameMapper;
        this.idManager = idManager;
    }

    @Override
    public String getOakNameOrNull(@Nonnull String jcrName) {
        return this.nameMapper.getOakNameOrNull(jcrName);
    }

    @Override
    @Nonnull
    public String getOakName(@Nonnull String jcrName) throws RepositoryException {
        return this.nameMapper.getOakName(jcrName);
    }

    @Override
    @Nonnull
    public String getJcrName(@Nonnull String oakName) {
        return this.nameMapper.getJcrName(oakName);
    }

    @Override
    @Nonnull
    public Map<String, String> getSessionLocalMappings() {
        return this.nameMapper.getSessionLocalMappings();
    }

    @Override
    public String getOakPath(String jcrPath) {
        if (!this.needsFullMapping(jcrPath)) {
            return jcrPath;
        }
        int length = jcrPath.length();
        if (length > 0 && jcrPath.charAt(0) == '[') {
            if (jcrPath.charAt(length - 1) != ']') {
                log.debug("Could not parse path " + jcrPath + ": unterminated identifier");
                return null;
            }
            if (this.idManager == null) {
                log.debug("Could not parse path " + jcrPath + ": could not resolve identifier");
                return null;
            }
            return this.idManager.getPath(jcrPath.substring(1, length - 1));
        }
        final StringBuilder parseErrors = new StringBuilder();
        PathListener listener = new PathListener(){

            @Override
            public void error(String message) {
                parseErrors.append(message);
            }

            @Override
            public boolean name(String name, int index) {
                if (index < 0) {
                    this.error("invalid index: " + index);
                    return false;
                }
                String oakName = NamePathMapperImpl.this.nameMapper.getOakNameOrNull(name);
                if (oakName == null) {
                    this.error("Invalid name: " + name);
                    return false;
                }
                if (index > 1) {
                    oakName = oakName + "[" + index + ']';
                }
                this.elements.add(oakName);
                return true;
            }
        };
        JcrPathParser.parse(jcrPath, listener);
        if (parseErrors.length() != 0) {
            log.debug("Could not parse path " + jcrPath + ": " + parseErrors.toString());
            return null;
        }
        if (listener.elements.isEmpty()) {
            return "";
        }
        StringBuilder oakPath = new StringBuilder();
        for (String element : listener.elements) {
            if (element.isEmpty()) {
                oakPath.append('/');
                continue;
            }
            oakPath.append(element);
            oakPath.append('/');
        }
        oakPath.deleteCharAt(oakPath.length() - 1);
        return oakPath.toString();
    }

    @Override
    @Nonnull
    public String getJcrPath(String oakPath) {
        if ("/".equals(oakPath)) {
            return "/";
        }
        if (oakPath.isEmpty()) {
            return ".";
        }
        if (this.nameMapper.getSessionLocalMappings().isEmpty()) {
            return oakPath;
        }
        PathListener listener = new PathListener(){

            @Override
            public boolean current() {
                return false;
            }

            @Override
            public void error(String message) {
                throw new IllegalArgumentException(message);
            }

            @Override
            public boolean name(String name, int index) {
                String p = NamePathMapperImpl.this.nameMapper.getJcrName(name);
                if (index == 0) {
                    this.elements.add(p);
                } else {
                    this.elements.add(p + '[' + index + ']');
                }
                return true;
            }
        };
        JcrPathParser.parse(oakPath, listener);
        StringBuilder jcrPath = new StringBuilder();
        for (String element : listener.elements) {
            if (element.isEmpty()) {
                jcrPath.append('/');
                continue;
            }
            jcrPath.append(element);
            jcrPath.append('/');
        }
        jcrPath.deleteCharAt(jcrPath.length() - 1);
        return jcrPath.toString();
    }

    private boolean needsFullMapping(String path) {
        int length = path.length();
        if (length == 0) {
            return true;
        }
        int slash = -1;
        int colon = -1;
        switch (path.charAt(0)) {
            case '.': 
            case ':': 
            case '[': 
            case '{': {
                return true;
            }
            case '/': {
                if (length == 1) {
                    return false;
                }
                slash = 0;
            }
        }
        block10: for (int i = 1; i < length; ++i) {
            switch (path.charAt(i)) {
                case '*': 
                case '[': 
                case ']': 
                case '{': 
                case '|': {
                    return true;
                }
                case '.': {
                    if (i != slash + 1) continue block10;
                    return true;
                }
                case ':': {
                    if (i == slash + 1 || i == colon + i || colon > slash || i + 1 == length) {
                        return true;
                    }
                    colon = i;
                    continue block10;
                }
                case '/': {
                    if (i == slash + 1 || i == colon + i || i + 1 == length) {
                        return true;
                    }
                    slash = i;
                }
            }
        }
        return colon != -1 && !this.nameMapper.getSessionLocalMappings().isEmpty();
    }

    private static abstract class PathListener
    implements JcrPathParser.Listener {
        final List<String> elements = new ArrayList<String>();

        private PathListener() {
        }

        @Override
        public boolean root() {
            if (!this.elements.isEmpty()) {
                this.error("/ on non-empty path");
                return false;
            }
            this.elements.add("");
            return true;
        }

        @Override
        public boolean current() {
            return true;
        }

        @Override
        public boolean parent() {
            String prevElem;
            int prevIdx = this.elements.size() - 1;
            String string = prevElem = prevIdx >= 0 ? this.elements.get(prevIdx) : null;
            if (prevElem == null || PathUtils.denotesParent(prevElem)) {
                this.elements.add("..");
                return true;
            }
            if (prevElem.isEmpty()) {
                this.error("Absolute path escapes root");
                return false;
            }
            this.elements.remove(prevIdx);
            return true;
        }
    }
}

