/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.core.data.CachingFDS;
import org.apache.jackrabbit.core.data.DataStoreException;

public class OakCachingFDS
extends CachingFDS {
    private String fsBackendPath;

    public void setFsBackendPath(String fsBackendPath) {
        this.fsBackendPath = fsBackendPath;
    }

    @Override
    protected byte[] getOrCreateReferenceKey() throws DataStoreException {
        File file = new File(this.fsBackendPath, "reference.key");
        try {
            if (file.exists()) {
                return FileUtils.readFileToByteArray((File)file);
            }
            byte[] key = new byte[256];
            new SecureRandom().nextBytes(key);
            FileUtils.writeByteArrayToFile((File)file, (byte[])key);
            return key;
        }
        catch (IOException e) {
            throw new DataStoreException("Unable to access reference key file " + file.getPath(), e);
        }
    }
}

