/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.identifier;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.text.ParseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.QueryEngine;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.QueryUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifierManager {
    private static final Logger log = LoggerFactory.getLogger(IdentifierManager.class);
    private final Root root;
    private final ReadOnlyNodeTypeManager nodeTypeManager;

    public IdentifierManager(Root root) {
        this.root = root;
        this.nodeTypeManager = ReadOnlyNodeTypeManager.getInstance(root, NamePathMapper.DEFAULT);
    }

    @Nonnull
    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    @Nonnull
    public static String generateUUID(String hint) {
        UUID uuid = UUID.nameUUIDFromBytes(hint.getBytes(Charsets.UTF_8));
        return uuid.toString();
    }

    public static boolean isValidUUID(String uuid) {
        try {
            UUID.fromString(uuid);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Nonnull
    public static String getIdentifier(Tree tree) {
        PropertyState property = tree.getProperty("jcr:uuid");
        if (property != null) {
            return property.getValue(Type.STRING);
        }
        if (tree.isRoot()) {
            return "/";
        }
        String parentId = IdentifierManager.getIdentifier(tree.getParent());
        return PathUtils.concat(parentId, tree.getName());
    }

    @CheckForNull
    public Tree getTree(String identifier) {
        if (identifier.startsWith("/")) {
            return this.root.getTree(identifier);
        }
        int k = identifier.indexOf(47);
        String uuid = k == -1 ? identifier : identifier.substring(0, k);
        Preconditions.checkArgument(IdentifierManager.isValidUUID(uuid), "Not a valid identifier '" + identifier + '\'');
        String basePath = this.resolveUUID(uuid);
        if (basePath == null) {
            return null;
        }
        if (k == -1) {
            return this.root.getTree(basePath);
        }
        return this.root.getTree(PathUtils.concat(basePath, identifier.substring(k + 1)));
    }

    @CheckForNull
    public String getPath(String identifier) {
        Tree tree = this.getTree(identifier);
        return tree != null && tree.exists() ? tree.getPath() : null;
    }

    @CheckForNull
    public String getPath(PropertyState referenceValue) {
        int type = referenceValue.getType().tag();
        if (type == 9 || type == 10) {
            return this.resolveUUID(referenceValue);
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @CheckForNull
    public String getPath(PropertyValue referenceValue) {
        int type = referenceValue.getType().tag();
        if (type == 9 || type == 10) {
            return this.resolveUUID(referenceValue);
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @Nonnull
    public Iterable<String> getReferences(boolean weak, @Nonnull Tree tree, @Nullable String propertyName) {
        if (!this.nodeTypeManager.isNodeType(tree, "mix:referenceable")) {
            return Collections.emptySet();
        }
        String uuid = IdentifierManager.getIdentifier(tree);
        String reference = weak ? "WeakReference" : "Reference";
        String pName = propertyName == null ? "*" : QueryUtils.escapeForQuery(propertyName);
        Map<String, PropertyValue> bindings = Collections.singletonMap("uuid", PropertyValues.newString(uuid));
        try {
            Result result = this.root.getQueryEngine().executeQuery("SELECT * FROM [nt:base] WHERE PROPERTY([" + pName + "], '" + reference + "') = $uuid" + " /* oak-internal */", "JCR-SQL2", bindings, QueryEngine.NO_MAPPINGS);
            return this.findPaths(result, uuid, propertyName, weak);
        }
        catch (ParseException e) {
            log.error("query failed", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @Nonnull
    private Iterable<String> findPaths(final @Nonnull Result result, final @Nonnull String uuid, final @Nullable String propertyName, final boolean weak) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return Iterators.concat(Iterators.transform(result.getRows().iterator(), new RowToPaths()));
            }

            class RowToPaths
            implements Function<ResultRow, Iterator<String>> {
                RowToPaths() {
                }

                @Override
                public Iterator<String> apply(ResultRow row) {
                    final String rowPath = row.getPath();
                    if (!rowPath.startsWith("/jcr:system/jcr:versionStorage")) {
                        if (propertyName == null) {
                            class PropertyToPath
                            implements Function<PropertyState, String> {
                                PropertyToPath() {
                                }

                                @Override
                                public String apply(PropertyState pState) {
                                    if (pState.isArray()) {
                                        Type<Iterable<String>> types;
                                        Type<Iterable<String>> type = types = weak ? Type.WEAKREFERENCES : Type.REFERENCES;
                                        if (pState.getType() == types) {
                                            for (String value : pState.getValue(Type.STRINGS)) {
                                                if (!uuid.equals(value)) continue;
                                                return PathUtils.concat(rowPath, pState.getName());
                                            }
                                        }
                                    } else {
                                        Type<String> type;
                                        Type<String> type2 = type = weak ? Type.WEAKREFERENCE : Type.REFERENCE;
                                        if (pState.getType() == type && uuid.equals(pState.getValue(Type.STRING))) {
                                            return PathUtils.concat(rowPath, pState.getName());
                                        }
                                    }
                                    return null;
                                }
                            }
                            return Iterators.filter(Iterators.transform(IdentifierManager.this.root.getTree(rowPath).getProperties().iterator(), new PropertyToPath()), Predicates.notNull());
                        }
                        return Iterators.singletonIterator(PathUtils.concat(rowPath, propertyName));
                    }
                    return Iterators.emptyIterator();
                }
            }
        };
    }

    @Nonnull
    public Iterable<String> getReferences(@Nonnull Tree tree, final @Nonnull String propertyName, @Nonnull String ntName, boolean weak) {
        if (!this.nodeTypeManager.isNodeType(tree, "mix:referenceable")) {
            return Collections.emptySet();
        }
        String uuid = IdentifierManager.getIdentifier(tree);
        String reference = weak ? "WeakReference" : "Reference";
        Map<String, PropertyValue> bindings = Collections.singletonMap("uuid", PropertyValues.newString(uuid));
        try {
            String escapedPropName = QueryUtils.escapeForQuery(propertyName);
            Result result = this.root.getQueryEngine().executeQuery("SELECT * FROM [" + ntName + "] WHERE PROPERTY([" + escapedPropName + "], '" + reference + "') = $uuid" + " /* oak-internal */", "JCR-SQL2", bindings, QueryEngine.NO_MAPPINGS);
            Iterable<String> resultPaths = Iterables.transform(result.getRows(), new Function<ResultRow, String>(){

                @Override
                public String apply(ResultRow row) {
                    return PathUtils.concat(row.getPath(), propertyName);
                }
            });
            return Iterables.filter(resultPaths, new Predicate<String>(){

                @Override
                public boolean apply(String path) {
                    return !path.startsWith("/jcr:system/jcr:versionStorage");
                }
            });
        }
        catch (ParseException e) {
            log.error("query failed", (Throwable)e);
            return Collections.emptySet();
        }
    }

    @CheckForNull
    public String resolveUUID(String uuid) {
        return this.resolveUUID(StringPropertyState.stringProperty("", uuid));
    }

    private String resolveUUID(PropertyState uuid) {
        return this.resolveUUID(PropertyValues.create(uuid));
    }

    private String resolveUUID(PropertyValue uuid) {
        try {
            Map<String, PropertyValue> bindings = Collections.singletonMap("id", uuid);
            Result result = this.root.getQueryEngine().executeQuery("SELECT * FROM [nt:base] WHERE [jcr:uuid] = $id /* oak-internal */", "JCR-SQL2", bindings, QueryEngine.NO_MAPPINGS);
            String path = null;
            for (ResultRow resultRow : result.getRows()) {
                if (path != null) {
                    log.error("multiple results for identifier lookup: " + path + " vs. " + resultRow.getPath());
                    return null;
                }
                path = resultRow.getPath();
            }
            return path;
        }
        catch (ParseException ex) {
            log.error("query failed", (Throwable)ex);
            return null;
        }
    }
}

