/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.IndexMBeanRegistration;
import org.apache.jackrabbit.oak.plugins.index.TrackingCorruptIndexHandler;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindex;
import org.apache.jackrabbit.oak.plugins.index.property.jmx.PropertyIndexAsyncReindexMBean;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.state.Clusterable;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardIndexEditorProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE, metatype=true, label="Apache Jackrabbit Oak Async Indexer Service", description="Configures the async indexer services which performs periodic indexing of repository content")
public class AsyncIndexerService {
    @Property(value={"async:5"}, cardinality=1024, label="Async Indexer Configs", description="Async indexer configs in the form of <name>:<interval in secs> e.g. \"async:5\"")
    private static final String PROP_ASYNC_CONFIG = "asyncConfigs";
    private static final int PROP_LEASE_TIMEOUT_DEFAULT = 15;
    @Property(intValue={15}, label="Lease time out", description="Lease timeout in minutes. AsyncIndexer would wait for this timeout period before breaking async indexer lease")
    private static final String PROP_LEASE_TIME_OUT = "leaseTimeOutMinutes";
    private static final long PROP_FAILING_INDEX_TIMEOUT_DEFAULT = 1800L;
    @Property(longValue={1800L}, label="Failing Index Timeout (s)", description="Time interval in seconds after which a failing index is considered as corrupted and ignored from further indexing untill reindex. To disable this set it to 0")
    private static final String PROP_FAILING_INDEX_TIMEOUT = "failingIndexTimeoutSeconds";
    private static final long PROP_ERROR_WARN_INTERVAL_DEFAULT = 900L;
    @Property(longValue={900L}, label="Error warn interval (s)", description="Time interval in seconds after which a warning log would be logged for skipped indexes. This is done to avoid flooding the log in case of corrupted index.")
    private static final String PROP_ERROR_WARN_INTERVAL = "errorWarnIntervalSeconds";
    private static final char CONFIG_SEP = ':';
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WhiteboardIndexEditorProvider indexEditorProvider = new WhiteboardIndexEditorProvider();
    @Reference
    private NodeStore nodeStore;
    @Reference(target="(type=changeCollectorProvider)")
    private ValidatorProvider validatorProvider;
    @Reference
    private StatisticsProvider statisticsProvider;
    private IndexMBeanRegistration indexRegistration;
    private final Closer closer = Closer.create();
    private WhiteboardExecutor executor;

    @Activate
    public void activate(BundleContext bundleContext, Map<String, Object> config) {
        List<AsyncConfig> asyncIndexerConfig = AsyncIndexerService.getAsyncConfig(PropertiesUtil.toStringArray(config.get(PROP_ASYNC_CONFIG), new String[0]));
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(bundleContext);
        this.indexRegistration = new IndexMBeanRegistration(whiteboard);
        this.indexEditorProvider.start(whiteboard);
        this.executor = new WhiteboardExecutor();
        this.executor.start(whiteboard);
        long leaseTimeOutMin = PropertiesUtil.toInteger(config.get(PROP_LEASE_TIME_OUT), 15);
        if (!(this.nodeStore instanceof Clusterable)) {
            leaseTimeOutMin = 0L;
            this.log.info("Detected non clusterable setup. Lease checking would be disabled for async indexing");
        }
        TrackingCorruptIndexHandler corruptIndexHandler = this.createCorruptIndexHandler(config);
        for (AsyncConfig c : asyncIndexerConfig) {
            AsyncIndexUpdate task = new AsyncIndexUpdate(c.name, this.nodeStore, this.indexEditorProvider, this.statisticsProvider, false);
            task.setCorruptIndexHandler(corruptIndexHandler);
            task.setValidatorProviders(Collections.singletonList(this.validatorProvider));
            task.setLeaseTimeOut(TimeUnit.MINUTES.toMillis(leaseTimeOutMin));
            this.indexRegistration.registerAsyncIndexer(task, c.timeIntervalInSecs);
            this.closer.register(task);
        }
        this.registerAsyncReindexSupport(whiteboard);
        this.log.info("Configured async indexers {} ", asyncIndexerConfig);
        this.log.info("Lease time: {} mins and AsyncIndexUpdate configured with {}", (Object)leaseTimeOutMin, (Object)this.validatorProvider.getClass().getName());
    }

    private void registerAsyncReindexSupport(Whiteboard whiteboard) {
        String name = "async-reindex";
        AsyncIndexUpdate task = new AsyncIndexUpdate(name, this.nodeStore, this.indexEditorProvider, this.statisticsProvider, true);
        PropertyIndexAsyncReindex asyncPI = new PropertyIndexAsyncReindex(task, this.executor);
        final CompositeRegistration reg = new CompositeRegistration(WhiteboardUtils.registerMBean(whiteboard, PropertyIndexAsyncReindexMBean.class, asyncPI, "PropertyIndexAsyncReindex", "async"), WhiteboardUtils.registerMBean(whiteboard, IndexStatsMBean.class, task.getIndexStats(), "IndexStats", name));
        this.closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                reg.unregister();
            }
        });
    }

    @Deactivate
    public void deactivate() throws IOException {
        if (this.indexRegistration != null) {
            this.indexRegistration.unregister();
        }
        if (this.executor != null) {
            this.executor.stop();
            this.executor = null;
        }
        this.closer.close();
    }

    private TrackingCorruptIndexHandler createCorruptIndexHandler(Map<String, Object> config) {
        long failingIndexTimeoutSeconds = PropertiesUtil.toLong(config.get(PROP_FAILING_INDEX_TIMEOUT), 1800L);
        long errorWarnIntervalSeconds = PropertiesUtil.toLong(config.get(PROP_ERROR_WARN_INTERVAL), 900L);
        TrackingCorruptIndexHandler corruptIndexHandler = new TrackingCorruptIndexHandler();
        corruptIndexHandler.setCorruptInterval(failingIndexTimeoutSeconds, TimeUnit.SECONDS);
        corruptIndexHandler.setErrorWarnInterval(errorWarnIntervalSeconds, TimeUnit.SECONDS);
        if (failingIndexTimeoutSeconds <= 0L) {
            this.log.info("[{}] is set to {}. Auto corrupt index isolation handling is disabled, warning log would be logged every {} s", new Object[]{PROP_FAILING_INDEX_TIMEOUT, failingIndexTimeoutSeconds, errorWarnIntervalSeconds});
        } else {
            this.log.info("Auto corrupt index isolation handling is enabled. Any async index which fails for {}s would be marked as corrupted and would be skipped from further indexing. A warning log would be logged every {} s", (Object)failingIndexTimeoutSeconds, (Object)errorWarnIntervalSeconds);
        }
        return corruptIndexHandler;
    }

    static List<AsyncConfig> getAsyncConfig(String[] configs) {
        ArrayList<AsyncConfig> result = Lists.newArrayList();
        for (String config : configs) {
            int idOfEq = config.indexOf(58);
            Preconditions.checkArgument(idOfEq > 0, "Invalid config provided [%s]", Arrays.toString(configs));
            String name = config.substring(0, idOfEq).trim();
            long interval = Long.parseLong(config.substring(idOfEq + 1));
            result.add(new AsyncConfig(name, interval));
        }
        return result;
    }

    protected void bindNodeStore(NodeStore nodeStore) {
        this.nodeStore = nodeStore;
    }

    protected void unbindNodeStore(NodeStore nodeStore) {
        if (this.nodeStore == nodeStore) {
            this.nodeStore = null;
        }
    }

    protected void bindValidatorProvider(ValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    protected void unbindValidatorProvider(ValidatorProvider validatorProvider) {
        if (this.validatorProvider == validatorProvider) {
            this.validatorProvider = null;
        }
    }

    protected void bindStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void unbindStatisticsProvider(StatisticsProvider statisticsProvider) {
        if (this.statisticsProvider == statisticsProvider) {
            this.statisticsProvider = null;
        }
    }

    static class AsyncConfig {
        final String name;
        final long timeIntervalInSecs;

        private AsyncConfig(String name, long timeIntervalInSecs) {
            this.name = AsyncIndexUpdate.checkValidName(name);
            this.timeIntervalInSecs = timeIntervalInSecs;
        }

        public String toString() {
            return "AsyncConfig{name='" + this.name + '\'' + ", timeIntervalInSecs=" + this.timeIntervalInSecs + '}';
        }
    }
}

