/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.counter;

import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.counter.NodeCounterEditor;
import org.apache.jackrabbit.oak.plugins.index.counter.jmx.NodeCounter;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

@Component
@Service(value={IndexEditorProvider.class})
public class NodeCounterEditorProvider
implements IndexEditorProvider {
    public static final String TYPE = "counter";
    public static final String RESOLUTION = "resolution";
    public static final String SEED = "seed";

    @Override
    @CheckForNull
    public Editor getIndexEditor(@Nonnull String type, @Nonnull NodeBuilder definition, @Nonnull NodeState root, @Nonnull IndexUpdateCallback callback) throws CommitFailedException {
        long seed;
        if (!TYPE.equals(type)) {
            return null;
        }
        PropertyState s = definition.getProperty(RESOLUTION);
        int resolution = s == null ? 1000 : s.getValue(Type.LONG).intValue();
        s = definition.getProperty(SEED);
        if (s != null) {
            seed = s.getValue(Type.LONG).intValue();
        } else {
            seed = 0L;
            if (NodeCounter.COUNT_HASH) {
                seed = UUID.randomUUID().getMostSignificantBits();
                definition.setProperty(SEED, seed);
            }
        }
        NodeCounterEditor.NodeCounterRoot rootData = new NodeCounterEditor.NodeCounterRoot(resolution, seed, definition, root, callback);
        return new NodeCounterEditor(rootData, null, "/", null);
    }
}

