/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BadIndexTracker {
    private static final long DEFAULT_RECHECK_INTERVAL = TimeUnit.MINUTES.toMillis(15L);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, BadIndexInfo> badIndexesForRead = Maps.newConcurrentMap();
    private final Map<String, BadIndexInfo> badPersistedIndexes = Maps.newConcurrentMap();
    private final long recheckIntervalMillis;
    private Ticker ticker = Ticker.systemTicker();
    private int indexerCycleCount;

    public BadIndexTracker() {
        this(DEFAULT_RECHECK_INTERVAL);
    }

    public BadIndexTracker(long recheckIntervalMillis) {
        this.recheckIntervalMillis = recheckIntervalMillis;
        this.log.info("Bad Index recheck interval set to {} seconds", (Object)TimeUnit.MILLISECONDS.toSeconds(recheckIntervalMillis));
    }

    public void markGoodIndexes(Set<String> updatedIndexPaths) {
        ++this.indexerCycleCount;
        for (String indexPath : updatedIndexPaths) {
            this.markGoodIndex(indexPath);
        }
    }

    public void markGoodIndex(String indexPath) {
        BadIndexInfo info = this.badIndexesForRead.remove(indexPath);
        this.badPersistedIndexes.remove(indexPath);
        if (info != null) {
            this.log.info("Index [{}] which was not working {} is found to be healthy again", (Object)indexPath, (Object)info.getStats());
        }
    }

    public void markBadPersistedIndex(String path, Throwable e) {
        BadIndexInfo badIndex = this.badPersistedIndexes.get(path);
        if (badIndex == null) {
            this.badPersistedIndexes.put(path, new BadIndexInfo(path, e, true));
            this.log.error("Could not open the Lucene index at [{}]", (Object)path, (Object)e);
        } else {
            badIndex.failedAccess(e);
            this.log.error("Could not open the Lucene index at [{}] . {}", new Object[]{path, badIndex.getStats(), e});
        }
    }

    public void markBadIndexForRead(String path, Throwable e) {
        BadIndexInfo badIndex = this.badIndexesForRead.get(path);
        if (badIndex == null) {
            this.badIndexesForRead.put(path, new BadIndexInfo(path, e, false));
            this.log.error("Could not access the Lucene index at [{}]", (Object)path, (Object)e);
        } else {
            badIndex.failedAccess(e);
            this.log.error("Could not access the Lucene index at [{}] . {}", new Object[]{path, badIndex.getStats(), e});
        }
    }

    public boolean isIgnoredBadIndex(String path) {
        BadIndexInfo badIdx = this.badIndexesForRead.get(path);
        if (badIdx == null) {
            return false;
        }
        return !badIdx.tryAgain();
    }

    public Set<String> getIndexPaths() {
        return this.badIndexesForRead.keySet();
    }

    BadIndexInfo getInfo(String indexPath) {
        return this.badIndexesForRead.get(indexPath);
    }

    Set<String> getBadPersistedIndexPaths() {
        return this.badPersistedIndexes.keySet();
    }

    BadIndexInfo getPersistedIndexInfo(String indexPath) {
        return this.badPersistedIndexes.get(indexPath);
    }

    public long getRecheckIntervalMillis() {
        return this.recheckIntervalMillis;
    }

    void setTicker(Ticker ticker) {
        this.ticker = ticker;
    }

    public boolean hasBadIndexes() {
        return !this.badIndexesForRead.isEmpty() || !this.badPersistedIndexes.isEmpty();
    }

    class BadIndexInfo {
        final String path;
        final int lastIndexerCycleCount;
        private final long createdTime;
        private final boolean persistedIndex;
        private final Stopwatch created;
        private final Stopwatch watch;
        private String exception;
        private int accessCount;
        private int failedAccessCount;

        public BadIndexInfo(String path, Throwable e, boolean persistedIndex) {
            this.lastIndexerCycleCount = BadIndexTracker.this.indexerCycleCount;
            this.createdTime = TimeUnit.NANOSECONDS.toMillis(BadIndexTracker.this.ticker.read());
            this.created = Stopwatch.createStarted(BadIndexTracker.this.ticker);
            this.watch = Stopwatch.createStarted(BadIndexTracker.this.ticker);
            this.path = path;
            this.exception = Throwables.getStackTraceAsString(e);
            this.persistedIndex = persistedIndex;
        }

        public boolean tryAgain() {
            ++this.accessCount;
            if (this.watch.elapsed(TimeUnit.MILLISECONDS) > BadIndexTracker.this.recheckIntervalMillis) {
                this.watch.reset().start();
                return true;
            }
            if (BadIndexTracker.this.log.isDebugEnabled()) {
                BadIndexTracker.this.log.debug("Ignoring index [{}] which is not working correctly {}", (Object)this.path, (Object)this.getStats());
            }
            return false;
        }

        public String getStats() {
            return String.format("since %s ,%d indexing cycles, accessed %d times", this.created, this.getCycleCount(), this.accessCount);
        }

        public int getFailedAccessCount() {
            return this.failedAccessCount;
        }

        public int getAccessCount() {
            return this.accessCount;
        }

        public String getException() {
            return this.exception;
        }

        public long getCreatedTime() {
            return this.createdTime;
        }

        public boolean isPersistedIndex() {
            return this.persistedIndex;
        }

        private int getCycleCount() {
            return BadIndexTracker.this.indexerCycleCount - this.lastIndexerCycleCount;
        }

        public void failedAccess(Throwable e) {
            ++this.failedAccessCount;
            this.exception = Throwables.getStackTraceAsString(e);
        }
    }
}

