/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.index.PathFilter;
import org.apache.jackrabbit.oak.plugins.index.lucene.Aggregate;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.NodeStateAnalyzerFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakAnalyzer;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakCodec;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.ConfigUtil;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.FunctionIndexProcessor;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.TokenizerChain;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.TreeFactory;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.path.PathHierarchyTokenizerFactory;
import org.apache.lucene.codecs.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexDefinition
implements Aggregate.AggregateMapper {
    private static final String OAK_CHILD_ORDER = ":childOrder";
    private static final Logger log = LoggerFactory.getLogger(IndexDefinition.class);
    private static boolean disableStoredIndexDefinition;
    static final int DEFAULT_ACTIVE_DELETE = -1;
    static final int DEFAULT_BLOB_SIZE = 1047552;
    static final long DEFAULT_ENTRY_COUNT = 1000L;
    public static final int DEFAULT_MAX_FIELD_LENGTH = 10000;
    static final int DEFAULT_MAX_EXTRACT_LENGTH = -10;
    static final String INDEX_VERSION = ":version";
    static final String INDEX_DEFINITION_NODE = ":index-definition";
    static final String STATUS_NODE = ":status";
    static final String PROP_UID = "uid";
    private static String TYPES_ALLOW_ALL_NAME;
    static final int TYPES_ALLOW_NONE = 0;
    static final int TYPES_ALLOW_ALL = -1;
    static final int DEFAULT_SUGGESTER_UPDATE_FREQUENCY_MINUTES = 10;
    static final int DEFAULT_FACET_COUNT = 10;
    static final QueryIndex.OrderEntry NATIVE_SORT_ORDER;
    private final boolean fullTextEnabled;
    private final NodeState definition;
    private final NodeState root;
    private final String funcName;
    private final int activeDelete;
    private final int blobSize;
    private final Codec codec;
    private final long entryCount;
    private final boolean entryCountDefined;
    private final double costPerEntry;
    private final double costPerExecution;
    private final Map<String, List<IndexingRule>> indexRules;
    private final List<IndexingRule> definedRules;
    private final String indexName;
    private final boolean testMode;
    private final boolean evaluatePathRestrictions;
    private final IndexFormatVersion version;
    private final Map<String, Aggregate> aggregates;
    private final boolean indexesAllTypes;
    private final Analyzer analyzer;
    private final String scorerProviderName;
    private final Map<String, Analyzer> analyzers;
    private final boolean hasCustomTikaConfig;
    private final int maxFieldLength;
    private final int maxExtractLength;
    private final int suggesterUpdateFrequencyMinutes;
    private final long reindexCount;
    private final PathFilter pathFilter;
    @Nullable
    private final String[] queryPaths;
    private final boolean saveDirListing;
    private final boolean suggestAnalyzed;
    private final boolean secureFacets;
    private final int numberOfTopFacets;
    private final boolean suggestEnabled;
    private final boolean spellcheckEnabled;
    private final String indexPath;
    private final boolean nrtIndexMode;
    private final boolean syncIndexMode;
    @Nullable
    private final String uid;

    public static Builder newBuilder(NodeState root, NodeState defn, String indexPath) {
        return new Builder(root, defn, indexPath);
    }

    public IndexDefinition(NodeState root, NodeState defn, String indexPath) {
        this(root, IndexDefinition.getIndexDefinitionState(defn), IndexDefinition.determineIndexFormatVersion(defn), IndexDefinition.determineUniqueId(defn), indexPath);
    }

    private IndexDefinition(NodeState root, NodeState defn, IndexFormatVersion version, String uid, String indexPath) {
        this.root = root;
        this.version = Preconditions.checkNotNull(version);
        this.uid = uid;
        this.definition = defn;
        this.indexPath = Preconditions.checkNotNull(indexPath);
        this.indexName = indexPath;
        this.blobSize = ConfigUtil.getOptionalValue(defn, "blobSize", 1047552);
        this.activeDelete = ConfigUtil.getOptionalValue(defn, "activeDelete", -1);
        this.testMode = ConfigUtil.getOptionalValue(defn, "testMode", false);
        this.aggregates = this.collectAggregates(defn);
        NodeState rulesState = defn.getChildNode("indexRules");
        if (!rulesState.exists()) {
            rulesState = IndexDefinition.createIndexRules(defn).getNodeState();
        }
        ArrayList<IndexingRule> definedIndexRules = Lists.newArrayList();
        this.indexRules = this.collectIndexRules(rulesState, definedIndexRules);
        this.definedRules = ImmutableList.copyOf(definedIndexRules);
        this.fullTextEnabled = IndexDefinition.hasFulltextEnabledIndexRule(definedIndexRules);
        this.evaluatePathRestrictions = ConfigUtil.getOptionalValue(defn, "evaluatePathRestrictions", false);
        String functionName = ConfigUtil.getOptionalValue(defn, "functionName", null);
        if (this.fullTextEnabled && functionName == null) {
            functionName = "lucene";
        }
        this.funcName = functionName != null ? "native*" + functionName : null;
        this.codec = this.createCodec();
        if (defn.hasProperty("entryCount")) {
            this.entryCountDefined = true;
            this.entryCount = defn.getProperty("entryCount").getValue(Type.LONG);
        } else {
            this.entryCountDefined = false;
            this.entryCount = 1000L;
        }
        this.maxFieldLength = ConfigUtil.getOptionalValue(defn, "maxFieldLength", 10000);
        this.costPerEntry = ConfigUtil.getOptionalValue(defn, "costPerEntry", IndexDefinition.getDefaultCostPerEntry(version));
        this.costPerExecution = ConfigUtil.getOptionalValue(defn, "costPerExecution", 1.0);
        this.indexesAllTypes = this.areAllTypesIndexed();
        this.analyzers = IndexDefinition.collectAnalyzers(defn);
        this.analyzer = this.createAnalyzer();
        this.hasCustomTikaConfig = this.getTikaConfigNode().exists();
        this.maxExtractLength = this.determineMaxExtractLength();
        this.suggesterUpdateFrequencyMinutes = this.evaluateSuggesterUpdateFrequencyMinutes(defn, 10);
        this.scorerProviderName = ConfigUtil.getOptionalValue(defn, "scorerProviderName", null);
        this.reindexCount = ConfigUtil.getOptionalValue(defn, "reindexCount", 0);
        this.pathFilter = PathFilter.from(new ReadOnlyBuilder(defn));
        this.queryPaths = this.getQueryPaths(defn);
        this.saveDirListing = ConfigUtil.getOptionalValue(defn, "saveDirectoryListing", true);
        this.suggestAnalyzed = this.evaluateSuggestAnalyzed(defn, false);
        if (defn.hasChildNode("facets")) {
            NodeState facetsConfig = defn.getChildNode("facets");
            this.secureFacets = ConfigUtil.getOptionalValue(facetsConfig, "secure", true);
            this.numberOfTopFacets = ConfigUtil.getOptionalValue(facetsConfig, "topChildren", 10);
        } else {
            this.secureFacets = true;
            this.numberOfTopFacets = 10;
        }
        this.suggestEnabled = this.evaluateSuggestionEnabled();
        this.spellcheckEnabled = this.evaluateSpellcheckEnabled();
        this.nrtIndexMode = IndexDefinition.supportsNRTIndexing(defn);
        this.syncIndexMode = IndexDefinition.supportsSyncIndexing(defn);
    }

    public NodeState getDefinitionNodeState() {
        return this.definition;
    }

    public boolean isFullTextEnabled() {
        return this.fullTextEnabled;
    }

    public String getFunctionName() {
        return this.funcName;
    }

    public boolean hasFunctionDefined() {
        return this.funcName != null;
    }

    public int getBlobSize() {
        return this.blobSize;
    }

    @CheckForNull
    public Codec getCodec() {
        return this.codec;
    }

    public long getReindexCount() {
        return this.reindexCount;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    private int evaluateSuggesterUpdateFrequencyMinutes(NodeState defn, int defaultValue) {
        NodeState suggestionConfig = defn.getChildNode("suggestion");
        if (!suggestionConfig.exists()) {
            return ConfigUtil.getOptionalValue(defn, "suggestUpdateFrequencyMinutes", defaultValue);
        }
        return ConfigUtil.getOptionalValue(suggestionConfig, "suggestUpdateFrequencyMinutes", defaultValue);
    }

    public int getSuggesterUpdateFrequencyMinutes() {
        return this.suggesterUpdateFrequencyMinutes;
    }

    public boolean isEntryCountDefined() {
        return this.entryCountDefined;
    }

    public double getCostPerEntry() {
        return this.costPerEntry;
    }

    public double getCostPerExecution() {
        return this.costPerExecution;
    }

    public long getFulltextEntryCount(long numOfDocs) {
        if (this.isEntryCountDefined()) {
            return Math.min(this.getEntryCount(), numOfDocs);
        }
        return numOfDocs;
    }

    public IndexFormatVersion getVersion() {
        return this.version;
    }

    public boolean isOfOldFormat() {
        return !IndexDefinition.hasIndexingRules(this.definition);
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public boolean evaluatePathRestrictions() {
        return this.evaluatePathRestrictions;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public boolean hasCustomTikaConfig() {
        return this.hasCustomTikaConfig;
    }

    public InputStream getTikaConfig() {
        return ConfigUtil.getBlob(this.getTikaConfigNode(), "config.xml").getNewStream();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getMaxExtractLength() {
        return this.maxExtractLength;
    }

    public String getScorerProviderName() {
        return this.scorerProviderName;
    }

    public boolean saveDirListing() {
        return this.saveDirListing;
    }

    public PathFilter getPathFilter() {
        return this.pathFilter;
    }

    @Nullable
    public String[] getQueryPaths() {
        return this.queryPaths;
    }

    @CheckForNull
    public String getUniqueId() {
        return this.uid;
    }

    public boolean isNRTIndexingEnabled() {
        return this.nrtIndexMode;
    }

    public boolean isSyncIndexingEnabled() {
        return this.syncIndexMode;
    }

    public static boolean hasPersistedIndex(NodeState definition) {
        for (String rm : definition.getChildNodeNames()) {
            if (!NodeStateUtils.isHidden(rm)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDisableStoredIndexDefinition() {
        return disableStoredIndexDefinition;
    }

    public static void setDisableStoredIndexDefinition(boolean disableStoredIndexDefinitionDefault) {
        disableStoredIndexDefinition = disableStoredIndexDefinitionDefault;
    }

    public String toString() {
        return "Lucene Index : " + this.indexName;
    }

    private Analyzer createAnalyzer() {
        Analyzer result;
        Analyzer defaultAnalyzer = LuceneIndexConstants.ANALYZER;
        if (this.analyzers.containsKey("default")) {
            defaultAnalyzer = this.analyzers.get("default");
        }
        if (!this.evaluatePathRestrictions()) {
            result = defaultAnalyzer;
        } else {
            ImmutableMap<String, Analyzer> analyzerMap = ImmutableMap.builder().put(":ancestors", new TokenizerChain(new PathHierarchyTokenizerFactory(Collections.emptyMap()))).build();
            result = new PerFieldAnalyzerWrapper(defaultAnalyzer, analyzerMap);
        }
        if (this.maxFieldLength < 0) {
            return result;
        }
        return new LimitTokenCountAnalyzer(result, this.maxFieldLength);
    }

    private static Map<String, Analyzer> collectAnalyzers(NodeState defn) {
        HashMap<String, Analyzer> analyzerMap = Maps.newHashMap();
        NodeStateAnalyzerFactory factory = new NodeStateAnalyzerFactory(LuceneIndexConstants.VERSION);
        NodeState analyzersTree = defn.getChildNode("analyzers");
        for (ChildNodeEntry childNodeEntry : analyzersTree.getChildNodeEntries()) {
            Analyzer a = factory.createInstance(childNodeEntry.getNodeState());
            analyzerMap.put(childNodeEntry.getName(), a);
        }
        if (ConfigUtil.getOptionalValue(analyzersTree, "indexOriginalTerm", false) && !analyzerMap.containsKey("default")) {
            analyzerMap.put("default", new OakAnalyzer(LuceneIndexConstants.VERSION, true));
        }
        return ImmutableMap.copyOf(analyzerMap);
    }

    @Override
    @CheckForNull
    public Aggregate getAggregate(String nodeType) {
        Aggregate agg = this.aggregates.get(nodeType);
        return agg != null ? agg : null;
    }

    private Map<String, Aggregate> collectAggregates(NodeState defn) {
        HashMap<String, Aggregate> aggregateMap = Maps.newHashMap();
        for (ChildNodeEntry childNodeEntry : defn.getChildNode("aggregates").getChildNodeEntries()) {
            String nodeType = childNodeEntry.getName();
            int recursionLimit = ConfigUtil.getOptionalValue(childNodeEntry.getNodeState(), "reaggregateLimit", 5);
            ArrayList<Aggregate.NodeInclude> includes = Lists.newArrayList();
            for (ChildNodeEntry childNodeEntry2 : childNodeEntry.getNodeState().getChildNodeEntries()) {
                NodeState is = childNodeEntry2.getNodeState();
                String primaryType = is.getString("primaryType");
                String path = is.getString("path");
                boolean relativeNode = ConfigUtil.getOptionalValue(is, "relativeNode", false);
                if (path == null) {
                    log.warn("Aggregate pattern in {} does not have required property [{}]. {} aggregate rule would be ignored", new Object[]{this, "path", childNodeEntry2.getName()});
                    continue;
                }
                includes.add(new Aggregate.NodeInclude(this, primaryType, path, relativeNode));
            }
            aggregateMap.put(nodeType, new Aggregate(nodeType, includes, recursionLimit));
        }
        return ImmutableMap.copyOf(aggregateMap);
    }

    public boolean hasMatchingNodeTypeReg(NodeState root) {
        return this.root.getChildNode("jcr:system").getChildNode("jcr:nodeTypes").equals(root.getChildNode("jcr:system").getChildNode("jcr:nodeTypes"));
    }

    public List<IndexingRule> getDefinedRules() {
        return this.definedRules;
    }

    @CheckForNull
    public IndexingRule getApplicableIndexingRule(String primaryNodeType) {
        ArrayList<IndexingRule> rules = null;
        List<IndexingRule> r = this.indexRules.get(primaryNodeType);
        if (r != null) {
            rules = new ArrayList<IndexingRule>();
            rules.addAll(r);
        }
        if (rules != null) {
            for (IndexingRule rule : rules) {
                if (!rule.appliesTo(primaryNodeType)) continue;
                return rule;
            }
        }
        return null;
    }

    @CheckForNull
    public IndexingRule getApplicableIndexingRule(NodeState state) {
        ArrayList<IndexingRule> rules = null;
        List<IndexingRule> r = this.indexRules.get(IndexDefinition.getPrimaryTypeName(state));
        if (r != null) {
            rules = new ArrayList<IndexingRule>();
            rules.addAll(r);
        }
        for (String name : IndexDefinition.getMixinTypeNames(state)) {
            r = this.indexRules.get(name);
            if (r == null) continue;
            if (rules == null) {
                rules = new ArrayList();
            }
            rules.addAll(r);
        }
        if (rules != null) {
            for (IndexingRule rule : rules) {
                if (!rule.appliesTo(state)) continue;
                return rule;
            }
        }
        return null;
    }

    private Map<String, List<IndexingRule>> collectIndexRules(NodeState indexRules, List<IndexingRule> definedIndexRules) {
        if (!indexRules.exists()) {
            return Collections.emptyMap();
        }
        if (!IndexDefinition.hasOrderableChildren(indexRules)) {
            log.warn("IndexRule node does not have orderable children in [{}]", (Object)this);
        }
        HashMap nt2rules = Maps.newHashMap();
        ReadOnlyNodeTypeManager ntReg = IndexDefinition.createNodeTypeManager(TreeFactory.createReadOnlyTree(this.root));
        Tree ruleTree = TreeFactory.createReadOnlyTree(indexRules);
        List<String> allNames = IndexDefinition.getAllNodeTypes(ntReg);
        for (Tree tree : ruleTree.getChildren()) {
            IndexingRule rule = new IndexingRule(tree.getName(), indexRules.getChildNode(tree.getName()));
            definedIndexRules.add(rule);
            log.trace("Found rule '{}' for NodeType '{}'", (Object)rule, (Object)rule.getNodeTypeName());
            List<String> ntNames = allNames;
            if (!rule.inherited) {
                ntNames = Collections.singletonList(rule.getNodeTypeName());
            }
            for (String ntName : ntNames) {
                if (!ntReg.isNodeType(ntName, rule.getNodeTypeName())) continue;
                ArrayList<IndexingRule> perNtConfig = (ArrayList<IndexingRule>)nt2rules.get(ntName);
                if (perNtConfig == null) {
                    perNtConfig = new ArrayList<IndexingRule>();
                    nt2rules.put(ntName, perNtConfig);
                }
                log.trace("Registering rule '{}' for name '{}'", (Object)rule, (Object)ntName);
                perNtConfig.add(new IndexingRule(rule, ntName));
            }
        }
        for (Map.Entry entry : nt2rules.entrySet()) {
            entry.setValue(ImmutableList.copyOf((Collection)entry.getValue()));
        }
        return ImmutableMap.copyOf(nt2rules);
    }

    private boolean areAllTypesIndexed() {
        IndexingRule ntBaseRule = this.getApplicableIndexingRule("nt:base");
        return ntBaseRule != null;
    }

    private boolean evaluateSuggestionEnabled() {
        for (IndexingRule indexingRule : this.definedRules) {
            for (PropertyDefinition propertyDefinition : indexingRule.propConfigs.values()) {
                if (!propertyDefinition.useInSuggest) continue;
                return true;
            }
            for (NamePattern np : indexingRule.namePatterns) {
                if (!np.getConfig().useInSuggest) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSuggestEnabled() {
        return this.suggestEnabled;
    }

    private boolean evaluateSpellcheckEnabled() {
        for (IndexingRule indexingRule : this.definedRules) {
            for (PropertyDefinition propertyDefinition : indexingRule.propConfigs.values()) {
                if (!propertyDefinition.useInSpellcheck) continue;
                return true;
            }
            for (NamePattern np : indexingRule.namePatterns) {
                if (!np.getConfig().useInSpellcheck) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSpellcheckEnabled() {
        return this.spellcheckEnabled;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    private boolean evaluateSuggestAnalyzed(NodeState defn, boolean defaultValue) {
        NodeState suggestionConfig = defn.getChildNode("suggestion");
        if (!suggestionConfig.exists()) {
            return ConfigUtil.getOptionalValue(defn, "suggestAnalyzed", defaultValue);
        }
        return ConfigUtil.getOptionalValue(suggestionConfig, "suggestAnalyzed", defaultValue);
    }

    public boolean isSuggestAnalyzed() {
        return this.suggestAnalyzed;
    }

    public boolean isSecureFacets() {
        return this.secureFacets;
    }

    public int getNumberOfTopFacets() {
        return this.numberOfTopFacets;
    }

    public static NodeBuilder updateDefinition(NodeBuilder indexDefn) {
        return IndexDefinition.updateDefinition(indexDefn, "unknown");
    }

    public static NodeBuilder updateDefinition(NodeBuilder indexDefn, String indexPath) {
        NodeState defn = indexDefn.getBaseState();
        if (!IndexDefinition.hasIndexingRules(defn)) {
            NodeState rulesState = IndexDefinition.createIndexRules(defn).getNodeState();
            indexDefn.setChildNode("indexRules", rulesState);
            indexDefn.setProperty(INDEX_VERSION, IndexDefinition.determineIndexFormatVersion(defn).getVersion());
            indexDefn.removeProperty("declaringNodeTypes");
            indexDefn.removeProperty("includePropertyNames");
            indexDefn.removeProperty("excludePropertyNames");
            indexDefn.removeProperty("orderedProps");
            indexDefn.removeProperty("fulltextEnabled");
            indexDefn.child("properties").remove();
            log.info("Updated index definition for {}", (Object)indexPath);
        }
        return indexDefn;
    }

    private static NodeBuilder createIndexRules(NodeState defn) {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        Set<String> declaringNodeTypes = IndexDefinition.getMultiProperty(defn, "declaringNodeTypes");
        Set<String> includes = IndexDefinition.getMultiProperty(defn, "includePropertyNames");
        Set<String> excludes = IndexDefinition.toLowerCase(IndexDefinition.getMultiProperty(defn, "excludePropertyNames"));
        Set<String> orderedProps = IndexDefinition.getMultiProperty(defn, "orderedProps");
        boolean fullTextEnabled = ConfigUtil.getOptionalValue(defn, "fulltextEnabled", true);
        boolean storageEnabled = ConfigUtil.getOptionalValue(defn, "oak.experimental.storage", true);
        NodeState propNodeState = defn.getChildNode("properties");
        if (declaringNodeTypes.isEmpty()) {
            declaringNodeTypes = Collections.singleton("nt:base");
        }
        HashSet<String> propNamesSet = Sets.newHashSet();
        propNamesSet.addAll(includes);
        propNamesSet.addAll(excludes);
        propNamesSet.addAll(orderedProps);
        for (ChildNodeEntry childNodeEntry : propNodeState.getChildNodeEntries()) {
            if (propNamesSet.contains(childNodeEntry.getName()) || !Iterables.isEmpty(childNodeEntry.getNodeState().getChildNodeNames())) continue;
            propNamesSet.add(childNodeEntry.getName());
        }
        ArrayList<String> propNames = new ArrayList<String>(propNamesSet);
        String string = "^[^\\/]*$";
        if (fullTextEnabled && includes.isEmpty()) {
            propNames.add("^[^\\/]*$");
        }
        for (String typeName : declaringNodeTypes) {
            NodeBuilder rule = builder.child(typeName);
            IndexDefinition.markAsNtUnstructured(rule);
            ArrayList<String> propNodeNames = Lists.newArrayListWithCapacity(propNamesSet.size());
            NodeBuilder propNodes = rule.child("properties");
            int i = 0;
            Iterator i$ = propNames.iterator();
            while (i$.hasNext()) {
                NodeState propDefNode;
                String propName;
                String propNodeName = propName = (String)i$.next();
                if (PropertyDefinition.isRelativeProperty(propName) || propName.equals("^[^\\/]*$")) {
                    propNodeName = "prop" + i++;
                }
                propNodeNames.add(propNodeName);
                NodeBuilder prop = propNodes.child(propNodeName);
                IndexDefinition.markAsNtUnstructured(prop);
                prop.setProperty("name", propName);
                if (excludes.contains(propName)) {
                    prop.setProperty("index", false);
                } else if (fullTextEnabled) {
                    prop.setProperty("analyzed", true);
                    prop.setProperty("nodeScopeIndex", true);
                    prop.setProperty("useInExcerpt", storageEnabled);
                    prop.setProperty("propertyIndex", false);
                } else {
                    prop.setProperty("propertyIndex", true);
                    if (orderedProps.contains(propName)) {
                        prop.setProperty("ordered", true);
                    }
                }
                if (propName.equals("^[^\\/]*$")) {
                    prop.setProperty("isRegexp", true);
                }
                if ((propDefNode = IndexDefinition.getPropDefnNode(defn, propName)) == null) continue;
                for (PropertyState propertyState : propDefNode.getProperties()) {
                    prop.setProperty(propertyState);
                }
            }
            PropertyState supportedTypes = defn.getProperty("includePropertyTypes");
            if (supportedTypes == null) {
                supportedTypes = PropertyStates.createProperty("includePropertyTypes", TYPES_ALLOW_ALL_NAME);
            }
            rule.setProperty(supportedTypes);
            if (!"nt:base".equals(typeName)) {
                rule.setProperty("inherited", false);
            }
            propNodes.setProperty(OAK_CHILD_ORDER, propNodeNames, Type.NAMES);
            IndexDefinition.markAsNtUnstructured(propNodes);
        }
        IndexDefinition.markAsNtUnstructured(builder);
        builder.setProperty(OAK_CHILD_ORDER, declaringNodeTypes, Type.NAMES);
        return builder;
    }

    private static NodeState getPropDefnNode(NodeState defn, String propName) {
        NodeState propDefNode;
        NodeState propNode = defn.getChildNode("properties");
        if (PropertyDefinition.isRelativeProperty(propName)) {
            NodeState result = propNode;
            for (String name : PathUtils.elements(propName)) {
                result = result.getChildNode(name);
            }
            propDefNode = result;
        } else {
            propDefNode = propNode.getChildNode(propName);
        }
        return propDefNode.exists() ? propDefNode : null;
    }

    private int determineMaxExtractLength() {
        int length = ConfigUtil.getOptionalValue(this.definition.getChildNode("tika"), "maxExtractLength", -10);
        if (length < 0) {
            return -length * this.maxFieldLength;
        }
        return length;
    }

    private NodeState getTikaConfigNode() {
        return this.definition.getChildNode("tika").getChildNode("config.xml");
    }

    private Codec createCodec() {
        String codecName = ConfigUtil.getOptionalValue(this.definition, "codec", null);
        Codec codec = null;
        if (codecName != null) {
            OakCodec ensureLucene46CodecLoaded = new OakCodec();
            log.debug("Lucene46Codec is loaded: {}", (Object)ensureLucene46CodecLoaded);
            codec = Codec.forName(codecName);
            log.debug("Codec is loaded: {}", (Object)codecName);
        } else if (this.fullTextEnabled) {
            codec = new OakCodec();
        }
        return codec;
    }

    private static Set<String> getMultiProperty(NodeState definition, String propName) {
        PropertyState pse = definition.getProperty(propName);
        return pse != null ? ImmutableSet.copyOf(pse.getValue(Type.STRINGS)) : Collections.emptySet();
    }

    private static Set<String> toLowerCase(Set<String> values) {
        HashSet<String> result = Sets.newHashSet();
        for (String val : values) {
            result.add(val.toLowerCase());
        }
        return ImmutableSet.copyOf(result);
    }

    private static List<String> getAllNodeTypes(ReadOnlyNodeTypeManager ntReg) {
        try {
            ArrayList<String> typeNames = Lists.newArrayList();
            NodeTypeIterator ntItr = ntReg.getAllNodeTypes();
            while (ntItr.hasNext()) {
                typeNames.add(ntItr.nextNodeType().getName());
            }
            return typeNames;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private static ReadOnlyNodeTypeManager createNodeTypeManager(final Tree root) {
        return new ReadOnlyNodeTypeManager(){

            @Override
            protected Tree getTypes() {
                return TreeUtil.getTree(root, "/jcr:system/jcr:nodeTypes");
            }

            @Override
            @Nonnull
            protected NamePathMapper getNamePathMapper() {
                return NamePathMapper.DEFAULT;
            }
        };
    }

    private static String getPrimaryTypeName(NodeState state) {
        String primaryType = state.getName("jcr:primaryType");
        if (primaryType == null) {
            primaryType = state.getString("jcr:primaryType");
        }
        return primaryType != null ? primaryType : "nt:base";
    }

    private static Iterable<String> getMixinTypeNames(NodeState state) {
        PropertyState property = state.getProperty("jcr:mixinTypes");
        return property != null ? property.getValue(Type.NAMES) : Collections.emptyList();
    }

    private static boolean hasOrderableChildren(NodeState state) {
        return state.hasProperty(OAK_CHILD_ORDER);
    }

    static int getSupportedTypes(NodeState defn, String typePropertyName, int defaultVal) {
        PropertyState pst = defn.getProperty(typePropertyName);
        if (pst != null) {
            int types = 0;
            for (String inc : pst.getValue(Type.STRINGS)) {
                if (TYPES_ALLOW_ALL_NAME.equals(inc)) {
                    return -1;
                }
                try {
                    types |= 1 << PropertyType.valueFromName((String)inc);
                }
                catch (IllegalArgumentException e) {
                    log.warn("Unknown property type: " + inc);
                }
            }
            return types;
        }
        return defaultVal;
    }

    static boolean includePropertyType(int includedPropertyTypes, int type) {
        if (includedPropertyTypes == -1) {
            return true;
        }
        if (includedPropertyTypes == 0) {
            return false;
        }
        return (includedPropertyTypes & 1 << type) != 0;
    }

    private static boolean hasFulltextEnabledIndexRule(List<IndexingRule> rules) {
        for (IndexingRule rule : rules) {
            if (!rule.isFulltextEnabled()) continue;
            return true;
        }
        return false;
    }

    private static void markAsNtUnstructured(NodeBuilder nb) {
        nb.setProperty("jcr:primaryType", "nt:unstructured", Type.NAME);
    }

    private static IndexFormatVersion determineIndexFormatVersion(NodeState defn) {
        if (defn.hasProperty("compatVersion")) {
            return IndexDefinition.versionFrom(defn.getProperty("compatVersion"));
        }
        if (defn.hasProperty(INDEX_VERSION)) {
            return IndexDefinition.versionFrom(defn.getProperty(INDEX_VERSION));
        }
        if (!defn.getChildNode(":data").exists()) {
            return IndexDefinition.determineVersionForFreshIndex(defn);
        }
        boolean fullTextEnabled = ConfigUtil.getOptionalValue(defn, "fulltextEnabled", true);
        return fullTextEnabled ? IndexFormatVersion.V1 : IndexFormatVersion.V2;
    }

    static IndexFormatVersion determineVersionForFreshIndex(NodeState defn) {
        return IndexDefinition.determineVersionForFreshIndex(defn.getProperty("fulltextEnabled"), defn.getProperty("compatVersion"), defn.getProperty(INDEX_VERSION));
    }

    static IndexFormatVersion determineVersionForFreshIndex(NodeBuilder defnb) {
        return IndexDefinition.determineVersionForFreshIndex(defnb.getProperty("fulltextEnabled"), defnb.getProperty("compatVersion"), defnb.getProperty(INDEX_VERSION));
    }

    private static IndexFormatVersion determineVersionForFreshIndex(PropertyState fulltext, PropertyState compat, PropertyState version) {
        if (compat != null) {
            return IndexDefinition.versionFrom(compat);
        }
        IndexFormatVersion defaultToUse = IndexFormatVersion.getDefault();
        IndexFormatVersion existing = version != null ? IndexDefinition.versionFrom(version) : null;
        IndexFormatVersion result = defaultToUse;
        if (existing != null) {
            result = IndexFormatVersion.max(result, existing);
        }
        if (fulltext != null && !fulltext.getValue(Type.BOOLEAN).booleanValue()) {
            return IndexFormatVersion.max(result, IndexFormatVersion.V2);
        }
        return result;
    }

    private String[] getQueryPaths(NodeState defn) {
        PropertyState ps = defn.getProperty("queryPaths");
        if (ps != null) {
            return Iterables.toArray(ps.getValue(Type.STRINGS), String.class);
        }
        return null;
    }

    private static IndexFormatVersion versionFrom(PropertyState ps) {
        return IndexFormatVersion.getVersion(Ints.checkedCast(ps.getValue(Type.LONG)));
    }

    private static boolean hasIndexingRules(NodeState defn) {
        return defn.getChildNode("indexRules").exists();
    }

    @CheckForNull
    private static String determineUniqueId(NodeState defn) {
        return defn.getChildNode(STATUS_NODE).getString(PROP_UID);
    }

    public boolean getActiveDeleteEnabled() {
        return this.activeDelete >= 0;
    }

    private static double getDefaultCostPerEntry(IndexFormatVersion version) {
        return version == IndexFormatVersion.V1 ? 1.5 : 1.0;
    }

    private static boolean supportsNRTIndexing(NodeState defn) {
        return IndexDefinition.supportsIndexingMode(new ReadOnlyBuilder(defn), "nrt");
    }

    private static boolean supportsSyncIndexing(NodeState defn) {
        return IndexDefinition.supportsIndexingMode(new ReadOnlyBuilder(defn), "sync");
    }

    public static boolean supportsSyncOrNRTIndexing(NodeBuilder defn) {
        return IndexDefinition.supportsIndexingMode(defn, "nrt") || IndexDefinition.supportsIndexingMode(defn, "sync");
    }

    private static boolean supportsIndexingMode(NodeBuilder defn, String mode) {
        PropertyState async = defn.getProperty("async");
        if (async == null) {
            return false;
        }
        return Iterables.contains(async.getValue(Type.STRINGS), mode);
    }

    private static NodeState getIndexDefinitionState(NodeState defn) {
        if (IndexDefinition.isDisableStoredIndexDefinition()) {
            return defn;
        }
        NodeState storedState = defn.getChildNode(INDEX_DEFINITION_NODE);
        return storedState.exists() ? storedState : defn;
    }

    static {
        TYPES_ALLOW_ALL_NAME = "all";
        NATIVE_SORT_ORDER = new QueryIndex.OrderEntry("jcr:score", Type.UNDEFINED, QueryIndex.OrderEntry.Order.DESCENDING);
    }

    private static final class NamePattern {
        private final String parentPath;
        private final Pattern pattern;
        private final PropertyDefinition config;

        private NamePattern(String pattern, PropertyDefinition config) {
            if ("^[^\\/]*$".equals(pattern)) {
                this.parentPath = "";
                this.pattern = Pattern.compile(pattern);
            } else {
                this.parentPath = PathUtils.getParentPath(pattern);
                this.pattern = Pattern.compile(PathUtils.getName(pattern));
            }
            this.config = config;
        }

        boolean matches(String propertyPath) {
            String parentPath = PathUtils.getParentPath(propertyPath);
            String propertyName = PathUtils.getName(propertyPath);
            if (!this.parentPath.equals(parentPath)) {
                return false;
            }
            return this.pattern.matcher(propertyName).matches();
        }

        PropertyDefinition getConfig() {
            return this.config;
        }
    }

    public class IndexingRule {
        private final String baseNodeType;
        private final String nodeTypeName;
        private final Map<String, PropertyDefinition> propConfigs;
        private final List<NamePattern> namePatterns;
        private final List<PropertyDefinition> nullCheckEnabledProperties;
        private final List<PropertyDefinition> functionRestrictions;
        private final List<PropertyDefinition> notNullCheckEnabledProperties;
        private final List<PropertyDefinition> nodeScopeAnalyzedProps;
        private final boolean indexesAllNodesOfMatchingType;
        private final boolean nodeNameIndexed;
        final float boost;
        final boolean inherited;
        final int propertyTypes;
        final boolean fulltextEnabled;
        final boolean propertyIndexEnabled;
        final boolean nodeFullTextIndexed;
        final Aggregate aggregate;
        final Aggregate propAggregate;

        IndexingRule(String nodeTypeName, NodeState config) {
            this.nodeTypeName = nodeTypeName;
            this.baseNodeType = nodeTypeName;
            this.boost = ConfigUtil.getOptionalValue(config, "boost", 1.0f);
            this.inherited = ConfigUtil.getOptionalValue(config, "inherited", true);
            this.propertyTypes = IndexDefinition.getSupportedTypes(config, "includePropertyTypes", -1);
            ArrayList<NamePattern> namePatterns = Lists.newArrayList();
            ArrayList<PropertyDefinition> nonExistentProperties = Lists.newArrayList();
            ArrayList<PropertyDefinition> functionRestrictions = Lists.newArrayList();
            ArrayList<PropertyDefinition> existentProperties = Lists.newArrayList();
            ArrayList<PropertyDefinition> nodeScopeAnalyzedProps = Lists.newArrayList();
            ArrayList<Aggregate.Include> propIncludes = Lists.newArrayList();
            this.propConfigs = this.collectPropConfigs(config, namePatterns, propIncludes, nonExistentProperties, existentProperties, nodeScopeAnalyzedProps, functionRestrictions);
            this.propAggregate = new Aggregate(nodeTypeName, propIncludes);
            this.aggregate = this.combine(this.propAggregate, nodeTypeName);
            this.namePatterns = ImmutableList.copyOf(namePatterns);
            this.nodeScopeAnalyzedProps = ImmutableList.copyOf(nodeScopeAnalyzedProps);
            this.nullCheckEnabledProperties = ImmutableList.copyOf(nonExistentProperties);
            this.functionRestrictions = ImmutableList.copyOf(functionRestrictions);
            this.notNullCheckEnabledProperties = ImmutableList.copyOf(existentProperties);
            this.fulltextEnabled = this.aggregate.hasNodeAggregates() || this.hasAnyFullTextEnabledProperty();
            this.nodeFullTextIndexed = this.aggregate.hasNodeAggregates() || this.anyNodeScopeIndexedProperty();
            this.propertyIndexEnabled = this.hasAnyPropertyIndexConfigured();
            this.indexesAllNodesOfMatchingType = this.areAlMatchingNodeByTypeIndexed();
            this.nodeNameIndexed = this.evaluateNodeNameIndexed(config);
            this.validateRuleDefinition();
        }

        IndexingRule(IndexingRule original, String nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
            this.baseNodeType = original.getNodeTypeName();
            this.propConfigs = original.propConfigs;
            this.namePatterns = original.namePatterns;
            this.boost = original.boost;
            this.inherited = original.inherited;
            this.propertyTypes = original.propertyTypes;
            this.propertyIndexEnabled = original.propertyIndexEnabled;
            this.propAggregate = original.propAggregate;
            this.nullCheckEnabledProperties = original.nullCheckEnabledProperties;
            this.notNullCheckEnabledProperties = original.notNullCheckEnabledProperties;
            this.functionRestrictions = original.functionRestrictions;
            this.nodeScopeAnalyzedProps = original.nodeScopeAnalyzedProps;
            this.aggregate = this.combine(this.propAggregate, nodeTypeName);
            this.fulltextEnabled = this.aggregate.hasNodeAggregates() || original.fulltextEnabled;
            this.nodeFullTextIndexed = this.aggregate.hasNodeAggregates() || original.nodeFullTextIndexed;
            this.indexesAllNodesOfMatchingType = this.areAlMatchingNodeByTypeIndexed();
            this.nodeNameIndexed = original.nodeNameIndexed;
        }

        public boolean isIndexed(String propertyName) {
            return this.getConfig(propertyName) != null;
        }

        public String getNodeTypeName() {
            return this.nodeTypeName;
        }

        public String getBaseNodeType() {
            return this.baseNodeType;
        }

        public List<PropertyDefinition> getNullCheckEnabledProperties() {
            return this.nullCheckEnabledProperties;
        }

        public List<PropertyDefinition> getFunctionRestrictions() {
            return this.functionRestrictions;
        }

        public List<PropertyDefinition> getNotNullCheckEnabledProperties() {
            return this.notNullCheckEnabledProperties;
        }

        public List<PropertyDefinition> getNodeScopeAnalyzedProps() {
            return this.nodeScopeAnalyzedProps;
        }

        public String toString() {
            String str = "IndexRule: " + this.nodeTypeName;
            if (!this.baseNodeType.equals(this.nodeTypeName)) {
                str = str + "(" + this.baseNodeType + ")";
            }
            return str;
        }

        public boolean isAggregated(String nodePath) {
            return this.aggregate.hasRelativeNodeInclude(nodePath);
        }

        public boolean appliesTo(NodeState state) {
            for (String mixinName : IndexDefinition.getMixinTypeNames(state)) {
                if (!this.nodeTypeName.equals(mixinName)) continue;
                return true;
            }
            return this.nodeTypeName.equals(IndexDefinition.getPrimaryTypeName(state));
        }

        public boolean appliesTo(String nodeTypeName) {
            return this.nodeTypeName.equals(nodeTypeName);
        }

        public boolean isNodeNameIndexed() {
            return this.nodeNameIndexed;
        }

        public boolean isFulltextEnabled() {
            return this.fulltextEnabled;
        }

        public boolean isNodeFullTextIndexed() {
            return this.nodeFullTextIndexed;
        }

        @CheckForNull
        public PropertyDefinition getConfig(String propertyName) {
            PropertyDefinition config = this.propConfigs.get(propertyName.toLowerCase(Locale.ENGLISH));
            if (config != null) {
                return config;
            }
            if (this.namePatterns.size() > 0) {
                for (NamePattern np : this.namePatterns) {
                    if (!np.matches(propertyName)) continue;
                    return np.getConfig();
                }
            }
            return null;
        }

        public boolean includePropertyType(int type) {
            return IndexDefinition.includePropertyType(this.propertyTypes, type);
        }

        public Aggregate getAggregate() {
            return this.aggregate;
        }

        public boolean indexesAllNodesOfMatchingType() {
            return this.indexesAllNodesOfMatchingType;
        }

        public boolean isBasedOnNtBase() {
            return "nt:base".equals(this.baseNodeType);
        }

        private Map<String, PropertyDefinition> collectPropConfigs(NodeState config, List<NamePattern> patterns, List<Aggregate.Include> propAggregate, List<PropertyDefinition> nonExistentProperties, List<PropertyDefinition> existentProperties, List<PropertyDefinition> nodeScopeAnalyzedProps, List<PropertyDefinition> functionRestrictions) {
            HashMap<String, PropertyDefinition> propDefns = Maps.newHashMap();
            NodeState propNode = config.getChildNode("properties");
            if (!propNode.exists()) {
                return Collections.emptyMap();
            }
            if (!IndexDefinition.hasOrderableChildren(propNode)) {
                log.warn("Properties node for [{}] does not have orderable children in [{}]", (Object)this, (Object)IndexDefinition.this);
            }
            Tree propTree = TreeFactory.createReadOnlyTree(propNode);
            for (Tree prop : propTree.getChildren()) {
                String propName = prop.getName();
                NodeState propDefnNode = propNode.getChildNode(propName);
                if (!propDefnNode.exists() || propDefns.containsKey(propName)) continue;
                PropertyDefinition pd = new PropertyDefinition(this, propName, propDefnNode);
                if (pd.function != null) {
                    String[] properties;
                    functionRestrictions.add(pd);
                    for (String p : properties = FunctionIndexProcessor.getProperties(pd.functionCode)) {
                        if (PathUtils.getDepth(p) <= 1) continue;
                        PropertyDefinition pd2 = new PropertyDefinition(this, p, propDefnNode);
                        propAggregate.add(new Aggregate.PropertyInclude(pd2));
                    }
                    continue;
                }
                if (pd.isRegexp) {
                    patterns.add(new NamePattern(pd.name, pd));
                } else {
                    propDefns.put(pd.name.toLowerCase(Locale.ENGLISH), pd);
                }
                if (pd.relative) {
                    propAggregate.add(new Aggregate.PropertyInclude(pd));
                }
                if (pd.nullCheckEnabled) {
                    nonExistentProperties.add(pd);
                }
                if (pd.notNullCheckEnabled) {
                    existentProperties.add(pd);
                }
                if (!pd.nodeScopeIndex || !pd.analyzed || pd.isRegexp) continue;
                nodeScopeAnalyzedProps.add(pd);
            }
            return ImmutableMap.copyOf(propDefns);
        }

        private boolean hasAnyFullTextEnabledProperty() {
            for (PropertyDefinition pd : this.propConfigs.values()) {
                if (!pd.fulltextEnabled()) continue;
                return true;
            }
            for (NamePattern np : this.namePatterns) {
                if (!np.getConfig().fulltextEnabled()) continue;
                return true;
            }
            return false;
        }

        private boolean hasAnyPropertyIndexConfigured() {
            for (PropertyDefinition pd : this.propConfigs.values()) {
                if (!pd.propertyIndex) continue;
                return true;
            }
            for (NamePattern np : this.namePatterns) {
                if (!np.getConfig().propertyIndex) continue;
                return true;
            }
            return false;
        }

        private boolean anyNodeScopeIndexedProperty() {
            for (PropertyDefinition pd : this.propConfigs.values()) {
                if (!pd.nodeScopeIndex) continue;
                return true;
            }
            for (NamePattern np : this.namePatterns) {
                if (!np.getConfig().nodeScopeIndex) continue;
                return true;
            }
            return false;
        }

        private boolean areAlMatchingNodeByTypeIndexed() {
            if (this.nodeFullTextIndexed) {
                return true;
            }
            for (PropertyDefinition pd : this.nullCheckEnabledProperties) {
                if (pd.relative) continue;
                return true;
            }
            return this.getConfig("jcr:primaryType") != null;
        }

        private boolean evaluateNodeNameIndexed(NodeState config) {
            if (ConfigUtil.getOptionalValue(config, "indexNodeName", false)) {
                return true;
            }
            for (PropertyDefinition pd : this.propConfigs.values()) {
                if (!":nodeName".equals(pd.name)) continue;
                return true;
            }
            return false;
        }

        private Aggregate combine(Aggregate propAggregate, String nodeTypeName) {
            Aggregate nodeTypeAgg = IndexDefinition.this.getAggregate(nodeTypeName);
            ArrayList includes = Lists.newArrayList();
            includes.addAll(propAggregate.getIncludes());
            if (nodeTypeAgg != null) {
                includes.addAll(nodeTypeAgg.getIncludes());
            }
            return new Aggregate(nodeTypeName, includes);
        }

        private void validateRuleDefinition() {
            if (!this.nullCheckEnabledProperties.isEmpty() && this.isBasedOnNtBase()) {
                throw new IllegalStateException("nt:base based rule cannot have a PropertyDefinition with nullCheckEnabled");
            }
        }
    }

    public static class Builder {
        private static final String DEFAULT_UID = "0";
        private final NodeState root;
        private final NodeState defn;
        private final String indexPath;
        private IndexFormatVersion version;
        private String uid;
        private boolean reindexMode;

        public Builder(NodeState root, NodeState defn, String indexPath) {
            this.root = Preconditions.checkNotNull(root);
            this.defn = Preconditions.checkNotNull(defn);
            this.indexPath = Preconditions.checkNotNull(indexPath);
        }

        public Builder version(IndexFormatVersion version) {
            this.version = version;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Builder reindex() {
            this.reindexMode = true;
            return this;
        }

        public IndexDefinition build() {
            if (this.version == null) {
                this.version = IndexDefinition.determineIndexFormatVersion(this.defn);
            }
            if (this.uid == null) {
                this.uid = IndexDefinition.determineUniqueId(this.defn);
                if (this.uid == null && !IndexDefinition.hasPersistedIndex(this.defn)) {
                    this.uid = DEFAULT_UID;
                }
            }
            NodeState indexDefnStateToUse = this.defn;
            if (!this.reindexMode) {
                indexDefnStateToUse = IndexDefinition.getIndexDefinitionState(this.defn);
            }
            return new IndexDefinition(this.root, indexDefnStateToUse, this.version, this.uid, this.indexPath);
        }
    }
}

