/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.NRTIndex;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.NRTIndexFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.ReaderRefreshPolicy;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReader;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReaderFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexNode {
    static final String ASYNC = ":async";
    private static final AtomicInteger INDEX_NODE_COUNTER = new AtomicInteger();
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(IndexNode.class.getName() + ".perf")));
    private static final Logger log = LoggerFactory.getLogger(IndexNode.class);
    private final List<LuceneIndexReader> readers;
    private final String name;
    private final IndexDefinition definition;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile IndexSearcher indexSearcher;
    private final NRTIndex nrtIndex;
    private final ReaderRefreshPolicy refreshPolicy;
    private final Runnable refreshCallback = new Runnable(){

        @Override
        public void run() {
            IndexNode.this.refreshReaders();
        }
    };
    private boolean closed = false;
    private List<LuceneIndexReader> nrtReaders;
    private final int indexNodeId = INDEX_NODE_COUNTER.incrementAndGet();

    static IndexNode open(String indexPath, NodeState root, NodeState defnNodeState, LuceneIndexReaderFactory readerFactory, @Nullable NRTIndexFactory nrtFactory) throws IOException {
        NRTIndex nrtIndex;
        IndexDefinition definition = new IndexDefinition(root, defnNodeState, indexPath);
        List readers = readerFactory.createReaders(definition, defnNodeState, indexPath);
        NRTIndex nRTIndex = nrtIndex = nrtFactory != null ? nrtFactory.createIndex(definition) : null;
        if (!readers.isEmpty() || nrtIndex != null && !IndexNode.hasAsyncIndexerRun(root)) {
            return new IndexNode(PathUtils.getName(indexPath), definition, readers, nrtIndex);
        }
        return null;
    }

    static boolean hasAsyncIndexerRun(NodeState root) {
        return root.hasChildNode(ASYNC);
    }

    IndexNode(String name, IndexDefinition definition, List<LuceneIndexReader> readers, @Nullable NRTIndex nrtIndex) throws IOException {
        Preconditions.checkArgument(!readers.isEmpty() || nrtIndex != null);
        this.name = name;
        this.definition = definition;
        this.readers = readers;
        this.nrtIndex = nrtIndex;
        this.nrtReaders = this.getNRTReaders();
        this.indexSearcher = new IndexSearcher(this.createReader(this.nrtReaders));
        this.refreshPolicy = nrtIndex != null ? nrtIndex.getRefreshPolicy() : ReaderRefreshPolicy.NEVER;
    }

    String getName() {
        return this.name;
    }

    IndexDefinition getDefinition() {
        return this.definition;
    }

    public IndexSearcher getSearcher() {
        return this.indexSearcher;
    }

    @CheckForNull
    Directory getSuggestDirectory() {
        return this.readers.isEmpty() ? null : this.getDefaultReader().getSuggestDirectory();
    }

    @CheckForNull
    AnalyzingInfixSuggester getLookup() {
        return this.readers.isEmpty() ? null : this.getDefaultReader().getLookup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean acquire() {
        this.lock.readLock().lock();
        if (this.closed) {
            this.lock.readLock().unlock();
            return false;
        }
        boolean success = false;
        try {
            this.refreshPolicy.refreshOnReadIfRequired(this.refreshCallback);
            success = true;
            boolean bl = true;
            return bl;
        }
        finally {
            if (!success) {
                this.lock.readLock().unlock();
            }
        }
    }

    public void release() {
        this.lock.readLock().unlock();
    }

    public int getIndexNodeId() {
        return this.indexNodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        this.lock.writeLock().lock();
        try {
            Preconditions.checkState(!this.closed);
            this.closed = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
        for (LuceneIndexReader reader : Iterables.concat(this.readers, this.nrtReaders)) {
            reader.close();
        }
    }

    List<LuceneIndexReader> getPrimaryReaders() {
        return this.readers;
    }

    @CheckForNull
    public LuceneIndexWriter getLocalWriter() throws IOException {
        return this.nrtIndex != null ? this.nrtIndex.getWriter() : null;
    }

    public void refreshReadersOnWriteIfRequired() {
        this.refreshPolicy.refreshOnWriteIfRequired(this.refreshCallback);
    }

    private void refreshReaders() {
        long start = PERF_LOGGER.start();
        List<LuceneIndexReader> newNRTReaders = this.getNRTReaders();
        if (newNRTReaders != this.nrtReaders) {
            this.nrtReaders = newNRTReaders;
            this.indexSearcher = new IndexSearcher(this.createReader(this.nrtReaders));
            PERF_LOGGER.end(start, 0L, "Refreshed reader for index [{}]", (Object)this.definition);
        }
    }

    private LuceneIndexReader getDefaultReader() {
        return this.readers.get(0);
    }

    private IndexReader createReader(List<LuceneIndexReader> nrtReaders) {
        if (this.readers.size() == 1 && nrtReaders.isEmpty()) {
            return this.readers.get(0).getReader();
        }
        if (nrtReaders.size() == 1 && this.readers.isEmpty()) {
            return nrtReaders.get(0).getReader();
        }
        IndexReader[] readerArr = new IndexReader[this.readers.size() + nrtReaders.size()];
        int i = 0;
        for (LuceneIndexReader r : Iterables.concat(this.readers, nrtReaders)) {
            readerArr[i++] = r.getReader();
        }
        return new MultiReader(readerArr, true);
    }

    List<LuceneIndexReader> getNRTReaders() {
        return this.nrtIndex != null ? this.nrtIndex.getReaders() : Collections.emptyList();
    }
}

