/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.BadIndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.NRTIndexFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.DefaultIndexReaderFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReaderFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneIndexHelper;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.spi.commit.CompositeEditor;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.SubtreeEditor;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexTracker {
    private static final Logger log = LoggerFactory.getLogger(IndexTracker.class);
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(IndexTracker.class.getName() + ".perf")));
    private final LuceneIndexReaderFactory readerFactory;
    private final NRTIndexFactory nrtFactory;
    private final BadIndexTracker badIndexTracker = new BadIndexTracker();
    private NodeState root = EmptyNodeState.EMPTY_NODE;
    private volatile Map<String, IndexNode> indices = Collections.emptyMap();
    private volatile boolean refresh;

    public IndexTracker() {
        this((IndexCopier)null);
    }

    IndexTracker(IndexCopier cloner) {
        this((LuceneIndexReaderFactory)new DefaultIndexReaderFactory(Mounts.defaultMountInfoProvider(), cloner));
    }

    IndexTracker(LuceneIndexReaderFactory readerFactory) {
        this(readerFactory, null);
    }

    public IndexTracker(LuceneIndexReaderFactory readerFactory, @Nullable NRTIndexFactory nrtFactory) {
        this.readerFactory = readerFactory;
        this.nrtFactory = nrtFactory;
    }

    synchronized void close() {
        Map<String, IndexNode> indices = this.indices;
        this.indices = Collections.emptyMap();
        for (Map.Entry<String, IndexNode> entry : indices.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                log.error("Failed to close the Lucene index at " + entry.getKey(), (Throwable)e);
            }
        }
    }

    public synchronized void update(NodeState root) {
        if (this.refresh) {
            this.root = root;
            this.close();
            this.refresh = false;
            log.info("Refreshed the opened indexes");
        } else {
            this.diffAndUpdate(root);
        }
    }

    private synchronized void diffAndUpdate(final NodeState root) {
        Map<String, IndexNode> original = this.indices;
        final HashMap updates = Maps.newHashMap();
        HashSet<String> indexPaths = Sets.newHashSet();
        indexPaths.addAll(original.keySet());
        indexPaths.addAll(this.badIndexTracker.getIndexPaths());
        ArrayList<SubtreeEditor> editors = Lists.newArrayListWithCapacity(indexPaths.size());
        for (final String path : indexPaths) {
            editors.add(new SubtreeEditor((Editor)new DefaultEditor(){

                @Override
                public void leave(NodeState before, NodeState after) {
                    try {
                        long start = PERF_LOGGER.start();
                        IndexNode index = IndexNode.open(path, root, after, IndexTracker.this.readerFactory, IndexTracker.this.nrtFactory);
                        PERF_LOGGER.end(start, -1L, "[{}] Index found to be updated. Reopening the IndexNode", (Object)path);
                        updates.put(path, index);
                    }
                    catch (IOException e) {
                        IndexTracker.this.badIndexTracker.markBadPersistedIndex(path, e);
                    }
                }
            }, Iterables.toArray(PathUtils.elements(path), String.class)));
        }
        EditorDiff.process(CompositeEditor.compose(editors), this.root, root);
        this.root = root;
        if (!updates.isEmpty()) {
            this.indices = ImmutableMap.builder().putAll(Maps.filterKeys(original, Predicates.not(Predicates.in(updates.keySet())))).putAll(Maps.filterValues(updates, Predicates.notNull())).build();
            this.badIndexTracker.markGoodIndexes(updates.keySet());
            for (final String path : updates.keySet()) {
                IndexNode index = original.get(path);
                try {
                    if (index == null) continue;
                    index.close();
                }
                catch (IOException e) {
                    log.error("Failed to close Lucene index at " + path, (Throwable)e);
                }
            }
        }
    }

    void refresh() {
        this.refresh = true;
    }

    public IndexNode acquireIndexNode(String path) {
        IndexNode index = this.indices.get(path);
        if (index != null && index.acquire()) {
            return index;
        }
        return this.findIndexNode(path);
    }

    @CheckForNull
    public IndexDefinition getIndexDefinition(String indexPath) {
        IndexNode node = this.indices.get(indexPath);
        if (node != null) {
            return node.getDefinition();
        }
        return null;
    }

    Set<String> getIndexNodePaths() {
        return this.indices.keySet();
    }

    BadIndexTracker getBadIndexTracker() {
        return this.badIndexTracker;
    }

    NodeState getRoot() {
        return this.root;
    }

    private synchronized IndexNode findIndexNode(String path) {
        IndexNode index = this.indices.get(path);
        if (index != null) {
            Preconditions.checkState(index.acquire());
            return index;
        }
        if (this.badIndexTracker.isIgnoredBadIndex(path)) {
            return null;
        }
        NodeState node = this.root;
        for (String name : PathUtils.elements(path)) {
            node = node.getChildNode(name);
        }
        try {
            if (LuceneIndexHelper.isLuceneIndexNode(node)) {
                index = IndexNode.open(path, this.root, node, this.readerFactory, this.nrtFactory);
                if (index != null) {
                    Preconditions.checkState(index.acquire());
                    this.indices = ImmutableMap.builder().putAll(this.indices).put(path, index).build();
                    this.badIndexTracker.markGoodIndex(path);
                    return index;
                }
            } else if (node.exists()) {
                log.warn("Cannot open Lucene Index at path {} as the index is not of type {}", (Object)path, (Object)"lucene");
            }
        }
        catch (Throwable e) {
            this.badIndexTracker.markBadIndexForRead(path, e);
        }
        return null;
    }
}

