/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.ContextAwareCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.IndexingContext;
import org.apache.jackrabbit.oak.plugins.index.lucene.ExtractedTextCache;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditor;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorContext;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.IndexingQueue;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LocalIndexWriterFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.hybrid.LuceneDocumentHolder;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.DefaultIndexWriterFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.writer.LuceneIndexWriterFactory;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.CommitContext;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexEditorProvider
implements IndexEditorProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IndexCopier indexCopier;
    private final ExtractedTextCache extractedTextCache;
    private final IndexAugmentorFactory augmentorFactory;
    private LuceneIndexWriterFactory indexWriterFactory;
    private final IndexTracker indexTracker;
    private final MountInfoProvider mountInfoProvider;
    private GarbageCollectableBlobStore blobStore;
    private IndexingQueue indexingQueue;
    private int inMemoryDocsLimit = Integer.getInteger("oak.lucene.inMemoryDocsLimit", 500);

    public LuceneIndexEditorProvider() {
        this(null);
    }

    public LuceneIndexEditorProvider(@Nullable IndexCopier indexCopier) {
        this(indexCopier, new ExtractedTextCache(0L, 0L));
    }

    public LuceneIndexEditorProvider(@Nullable IndexCopier indexCopier, ExtractedTextCache extractedTextCache) {
        this(indexCopier, extractedTextCache, null, Mounts.defaultMountInfoProvider());
    }

    public LuceneIndexEditorProvider(@Nullable IndexCopier indexCopier, ExtractedTextCache extractedTextCache, @Nullable IndexAugmentorFactory augmentorFactory, MountInfoProvider mountInfoProvider) {
        this(indexCopier, null, extractedTextCache, augmentorFactory, mountInfoProvider);
    }

    public LuceneIndexEditorProvider(@Nullable IndexCopier indexCopier, @Nullable IndexTracker indexTracker, ExtractedTextCache extractedTextCache, @Nullable IndexAugmentorFactory augmentorFactory, MountInfoProvider mountInfoProvider) {
        this.indexCopier = indexCopier;
        this.indexTracker = indexTracker;
        this.extractedTextCache = extractedTextCache != null ? extractedTextCache : new ExtractedTextCache(0L, 0L);
        this.augmentorFactory = augmentorFactory;
        this.mountInfoProvider = Preconditions.checkNotNull(mountInfoProvider);
    }

    @Override
    public Editor getIndexEditor(@Nonnull String type, @Nonnull NodeBuilder definition, @Nonnull NodeState root, @Nonnull IndexUpdateCallback callback) throws CommitFailedException {
        if ("lucene".equals(type)) {
            Preconditions.checkArgument(callback instanceof ContextAwareCallback, "callback instance not of type ContextAwareCallback [%s]", callback);
            IndexingContext indexingContext = ((ContextAwareCallback)callback).getIndexingContext();
            LuceneIndexWriterFactory writerFactory = this.indexWriterFactory = new DefaultIndexWriterFactory(this.mountInfoProvider, this.indexCopier, this.blobStore);
            IndexDefinition indexDefinition = null;
            boolean asyncIndexing = true;
            if (!indexingContext.isAsync() && IndexDefinition.supportsSyncOrNRTIndexing(definition)) {
                if (indexingContext.isReindexing()) {
                    return null;
                }
                CommitContext commitContext = LuceneIndexEditorProvider.getCommitContext(indexingContext);
                if (commitContext == null) {
                    this.log.warn("No CommitContext found for commit", (Throwable)new Exception());
                    return null;
                }
                writerFactory = new LocalIndexWriterFactory(this.getDocumentHolder(commitContext), indexingContext.getIndexPath());
                if (this.indexTracker != null && (indexDefinition = this.indexTracker.getIndexDefinition(indexingContext.getIndexPath())) != null && !indexDefinition.hasMatchingNodeTypeReg(root)) {
                    this.log.debug("Detected change in NodeType registry for index {}. Would not use existing index definition", (Object)indexDefinition.getIndexPath());
                    indexDefinition = null;
                }
                definition = new ReadOnlyBuilder(definition.getNodeState());
                asyncIndexing = false;
            }
            LuceneIndexEditorContext context = new LuceneIndexEditorContext(root, definition, indexDefinition, callback, writerFactory, this.extractedTextCache, this.augmentorFactory, indexingContext, asyncIndexing);
            return new LuceneIndexEditor(context);
        }
        return null;
    }

    IndexCopier getIndexCopier() {
        return this.indexCopier;
    }

    IndexingQueue getIndexingQueue() {
        return this.indexingQueue;
    }

    ExtractedTextCache getExtractedTextCache() {
        return this.extractedTextCache;
    }

    public void setInMemoryDocsLimit(int inMemoryDocsLimit) {
        this.inMemoryDocsLimit = inMemoryDocsLimit;
    }

    private LuceneDocumentHolder getDocumentHolder(CommitContext commitContext) {
        LuceneDocumentHolder holder = (LuceneDocumentHolder)commitContext.get("luceneDocs");
        if (holder == null) {
            holder = new LuceneDocumentHolder(this.indexingQueue, this.inMemoryDocsLimit);
            commitContext.set("luceneDocs", holder);
        }
        return holder;
    }

    public void setBlobStore(@Nullable GarbageCollectableBlobStore blobStore) {
        this.blobStore = blobStore;
    }

    public void setIndexingQueue(IndexingQueue indexingQueue) {
        this.indexingQueue = indexingQueue;
    }

    GarbageCollectableBlobStore getBlobStore() {
        return this.blobStore;
    }

    private static CommitContext getCommitContext(IndexingContext indexingContext) {
        return (CommitContext)indexingContext.getCommitInfo().getInfo().get("oak.commitAttributes");
    }
}

