/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import javax.management.openmbean.TabularData;
import org.apache.jackrabbit.oak.commons.jmx.Description;
import org.apache.jackrabbit.oak.commons.jmx.Name;

public interface LuceneIndexMBean {
    public static final String TYPE = "LuceneIndex";

    public TabularData getIndexStats() throws IOException;

    public TabularData getBadIndexStats();

    public TabularData getBadPersistedIndexStats();

    public boolean isFailing();

    @Description(value="Determines the set of index paths upto given maxLevel. This can be used to determine the value for[includedPaths]. For this to work you should have [evaluatePathRestrictions] set to true in your index definition")
    public String[] getIndexedPaths(@Description(value="Index path for which stats are to be determined") @Name(value="indexPath") String var1, @Name(value="maxLevel") @Description(value="Maximum depth to examine. E.g. 5. Stats calculation would break out after this limit") int var2, @Description(value="Maximum number of unique paths to examine. E.g. 100. Stats calculation would break out after this limit") @Name(value="maxPathCount") int var3) throws IOException;

    @Description(value="Retrieves the fields, and number of documents for each field, for an index. This allows to investigate what is stored in the index.")
    public String[] getFieldInfo(@Name(value="indexPath") @Description(value="The index path (empty for all indexes)") String var1) throws IOException;

    @Description(value="Returns the stored index definition for index at given path in string form")
    public String getStoredIndexDefinition(@Name(value="indexPath") String var1);

    @Description(value="Returns the diff of index definition for index at given path from the stored index definition in string form")
    public String diffStoredIndexDefinition(@Name(value="indexPath") String var1);
}

