/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeTraverser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.commons.jmx.Name;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.json.JsopDiff;
import org.apache.jackrabbit.oak.plugins.index.lucene.BadIndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.LucenePropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.lucene.NodeStateCloner;
import org.apache.jackrabbit.oak.plugins.index.lucene.TermFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.DirectoryUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.reader.LuceneIndexReader;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndexMBeanImpl
extends AnnotatedStandardMBean
implements LuceneIndexMBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IndexTracker indexTracker;

    public LuceneIndexMBeanImpl(IndexTracker indexTracker) {
        super(LuceneIndexMBean.class);
        this.indexTracker = indexTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TabularData getIndexStats() throws IOException {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(LuceneIndexMBeanImpl.class.getName(), "Lucene Index Stats", IndexStats.TYPE, new String[]{"path"});
            tds = new TabularDataSupport(tt);
            Set<String> indexes = this.indexTracker.getIndexNodePaths();
            for (String path : indexes) {
                IndexNode indexNode = null;
                try {
                    indexNode = this.indexTracker.acquireIndexNode(path);
                    if (indexNode == null) continue;
                    IndexStats stats = new IndexStats(path, indexNode);
                    tds.put(stats.toCompositeData());
                }
                finally {
                    if (indexNode == null) continue;
                    indexNode.release();
                }
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Override
    public TabularData getBadIndexStats() {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(LuceneIndexMBeanImpl.class.getName(), "Lucene Bad Index Stats", BadIndexStats.TYPE, new String[]{"path"});
            tds = new TabularDataSupport(tt);
            Set<String> indexes = this.indexTracker.getBadIndexTracker().getIndexPaths();
            for (String path : indexes) {
                BadIndexTracker.BadIndexInfo info = this.indexTracker.getBadIndexTracker().getInfo(path);
                if (info == null) continue;
                BadIndexStats stats = new BadIndexStats(info);
                tds.put(stats.toCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Override
    public TabularData getBadPersistedIndexStats() {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(LuceneIndexMBeanImpl.class.getName(), "Lucene Bad Persisted Index Stats", BadIndexStats.TYPE, new String[]{"path"});
            tds = new TabularDataSupport(tt);
            Set<String> indexes = this.indexTracker.getBadIndexTracker().getBadPersistedIndexPaths();
            for (String path : indexes) {
                BadIndexTracker.BadIndexInfo info = this.indexTracker.getBadIndexTracker().getPersistedIndexInfo(path);
                if (info == null) continue;
                BadIndexStats stats = new BadIndexStats(info);
                tds.put(stats.toCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Override
    public boolean isFailing() {
        return this.indexTracker.getBadIndexTracker().hasBadIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getIndexedPaths(String indexPath, int maxLevel, int maxPathCount) throws IOException {
        IndexNode indexNode = null;
        try {
            if (indexPath == null) {
                indexPath = "/";
            }
            if ((indexNode = this.indexTracker.acquireIndexNode(indexPath)) != null) {
                IndexDefinition defn = indexNode.getDefinition();
                if (!defn.evaluatePathRestrictions()) {
                    String msg = String.format("Index at [%s] does not have [%s] enabled. So paths statistics cannot be determined for this index", indexPath, "evaluatePathRestrictions");
                    String[] stringArray = LuceneIndexMBeanImpl.createMsg(msg);
                    return stringArray;
                }
                IndexSearcher searcher = indexNode.getSearcher();
                String[] stringArray = LuceneIndexMBeanImpl.determineIndexedPaths(searcher, maxLevel, maxPathCount);
                return stringArray;
            }
        }
        finally {
            if (indexNode != null) {
                indexNode.release();
            }
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getFieldInfo(String indexPath) throws IOException {
        TreeSet<String> indexes = new TreeSet<String>();
        if (indexPath == null || indexPath.isEmpty()) {
            indexes.addAll(this.indexTracker.getIndexNodePaths());
        } else {
            indexes.add(indexPath);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String path : indexes) {
            IndexNode indexNode = null;
            try {
                indexNode = this.indexTracker.acquireIndexNode(path);
                if (indexNode == null) continue;
                IndexSearcher searcher = indexNode.getSearcher();
                list.addAll(LuceneIndexMBeanImpl.getFieldInfo(path, searcher));
            }
            finally {
                if (indexNode == null) continue;
                indexNode.release();
            }
        }
        return list.toArray(new String[0]);
    }

    @Override
    public String getStoredIndexDefinition(@Name(value="indexPath") String indexPath) {
        IndexDefinition defn = this.indexTracker.getIndexDefinition(indexPath);
        NodeState state = defn != null ? defn.getDefinitionNodeState() : NodeStateUtils.getNode(this.indexTracker.getRoot(), indexPath + "/" + ":index-definition");
        if (state.exists()) {
            return NodeStateUtils.toString(state);
        }
        return "No index found at given path";
    }

    @Override
    public String diffStoredIndexDefinition(@Name(value="indexPath") String indexPath) {
        NodeState stored = NodeStateUtils.getNode(this.indexTracker.getRoot(), indexPath + "/" + ":index-definition");
        NodeState current = NodeStateUtils.getNode(this.indexTracker.getRoot(), indexPath);
        if (stored.exists()) {
            current = NodeStateCloner.cloneVisibleState(current);
            JsopDiff diff = new JsopDiff();
            current.compareAgainstBaseState(stored, diff);
            return JsopBuilder.prettyPrint(diff.toString());
        }
        return "No stored index definition found at given path";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpIndexContent(String sourcePath, String destPath) throws IOException {
        IndexNode indexNode = null;
        try {
            if (sourcePath == null) {
                sourcePath = "/";
            }
            if ((indexNode = this.indexTracker.acquireIndexNode(sourcePath)) != null) {
                this.log.info("Dumping Lucene directory content for [{}] to [{}]", (Object)sourcePath, (Object)destPath);
                Directory source = LuceneIndexMBeanImpl.getDirectory(LuceneIndexMBeanImpl.getPrimaryReader(indexNode.getPrimaryReaders()));
                Preconditions.checkNotNull(source, "IndexSearcher not backed by DirectoryReader");
                FSDirectory dest = FSDirectory.open(new File(destPath));
                for (String file : source.listAll()) {
                    source.copy(dest, file, file, IOContext.DEFAULT);
                }
            }
        }
        finally {
            if (indexNode != null) {
                indexNode.release();
            }
        }
    }

    private static ArrayList<String> getFieldInfo(String path, IndexSearcher searcher) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        IndexReader reader = searcher.getIndexReader();
        Fields fields = MultiFields.getFields(reader);
        if (fields != null) {
            for (String f : fields) {
                list.add(path + " " + f + " " + reader.getDocCount(f));
            }
        }
        return list;
    }

    private static String[] determineIndexedPaths(IndexSearcher searcher, final int maxLevel, int maxPathCount) throws IOException {
        HashSet<String> paths = Sets.newHashSet();
        int startDepth = LuceneIndexMBeanImpl.getStartDepth(searcher, maxLevel);
        if (startDepth < 0) {
            return LuceneIndexMBeanImpl.createMsg("startDepth cannot be determined after search for upto maxLevel [" + maxLevel + "]");
        }
        SearchContext sc = new SearchContext(searcher);
        List<LuceneDoc> docs = LuceneIndexMBeanImpl.getDocsAtLevel(startDepth, sc);
        int maxPathLimitBreachedAtLevel = -1;
        block0: for (LuceneDoc doc : docs) {
            TreeTraverser<LuceneDoc> traverser = new TreeTraverser<LuceneDoc>(){

                @Override
                public Iterable<LuceneDoc> children(@Nonnull LuceneDoc root) {
                    if (root.depth >= maxLevel) {
                        return Collections.emptyList();
                    }
                    return root.getChildren();
                }
            };
            for (LuceneDoc node : traverser.breadthFirstTraversal(doc)) {
                if (paths.size() < maxPathCount) {
                    paths.add(node.path);
                    continue;
                }
                maxPathLimitBreachedAtLevel = node.depth;
                break block0;
            }
        }
        if (maxPathLimitBreachedAtLevel < 0) {
            return Iterables.toArray(paths, String.class);
        }
        HashSet<String> result = Sets.newHashSet();
        int safeDepth = maxPathLimitBreachedAtLevel - 1;
        if (safeDepth > 0) {
            for (String path : paths) {
                int pathDepth = PathUtils.getDepth(path);
                if (pathDepth != safeDepth) continue;
                result.add(path);
            }
        }
        return Iterables.toArray(result, String.class);
    }

    private static int getStartDepth(IndexSearcher searcher, int maxLevel) throws IOException {
        for (int depth = 0; depth < maxLevel; ++depth) {
            TopDocs docs = searcher.search(LuceneIndexMBeanImpl.newDepthQuery(depth), 1);
            if (docs.totalHits == 0) continue;
            return depth;
        }
        return -1;
    }

    private static List<LuceneDoc> getDocsAtLevel(int startDepth, SearchContext sc) throws IOException {
        TopDocs docs = sc.searcher.search(LuceneIndexMBeanImpl.newDepthQuery(startDepth), Integer.MAX_VALUE);
        return LuceneIndexMBeanImpl.getLuceneDocs(docs, sc);
    }

    private static List<LuceneDoc> getLuceneDocs(TopDocs docs, SearchContext sc) throws IOException {
        ArrayList<LuceneDoc> result = new ArrayList<LuceneDoc>(docs.scoreDocs.length);
        IndexReader reader = sc.searcher.getIndexReader();
        for (ScoreDoc doc : docs.scoreDocs) {
            result.add(new LuceneDoc(LuceneIndexMBeanImpl.getPath(reader, doc), sc));
        }
        return result;
    }

    private static String getPath(IndexReader reader, ScoreDoc doc) throws IOException {
        LucenePropertyIndex.PathStoredFieldVisitor visitor = new LucenePropertyIndex.PathStoredFieldVisitor();
        reader.document(doc.doc, visitor);
        return visitor.getPath();
    }

    private static Query newDepthQuery(String path) {
        int depth = PathUtils.getDepth(path) + 1;
        return LuceneIndexMBeanImpl.newDepthQuery(depth);
    }

    private static Query newDepthQuery(int depth) {
        return NumericRangeQuery.newIntRange(":depth", depth, depth, true, true);
    }

    private static String[] createMsg(String msg) {
        return new String[]{msg};
    }

    private static IndexReader getPrimaryReader(List<LuceneIndexReader> indexReaders) {
        return indexReaders.isEmpty() ? null : indexReaders.get(0).getReader();
    }

    private static long getIndexSize(List<LuceneIndexReader> readers) throws IOException {
        long totalSize = 0L;
        for (LuceneIndexReader r : readers) {
            totalSize += r.getIndexSize();
        }
        return totalSize;
    }

    private static Directory getDirectory(IndexReader reader) {
        if (reader instanceof DirectoryReader) {
            return ((DirectoryReader)reader).directory();
        }
        return null;
    }

    private static int getNumDocs(List<LuceneIndexReader> readers) {
        int numDoc = 0;
        for (LuceneIndexReader r : readers) {
            numDoc += r.getReader().numDocs();
        }
        return numDoc;
    }

    private static class BadIndexStats {
        static final String[] FIELD_NAMES = new String[]{"path", "stats", "failingSince", "exception"};
        static final String[] FIELD_DESCRIPTIONS = new String[]{"Path", "Failure stats", "Failure start time", "Exception"};
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        static final CompositeType TYPE = BadIndexStats.createCompositeType();
        private final BadIndexTracker.BadIndexInfo info;

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(BadIndexStats.class.getName(), "Composite data type for Lucene Bad Index statistics", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public BadIndexStats(BadIndexTracker.BadIndexInfo info) {
            this.info = info;
        }

        CompositeDataSupport toCompositeData() {
            Object[] values = new Object[]{this.info.path, this.info.getStats(), String.format("%tc", this.info.getCreatedTime()), this.info.getException()};
            try {
                return new CompositeDataSupport(TYPE, FIELD_NAMES, values);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class IndexStats {
        static final String[] FIELD_NAMES = new String[]{"path", "indexSizeStr", "indexSize", "suggesterSizeStr", "suggesterSize", "numDocs", "maxDoc", "numDeletedDocs", "nrtIndexSize", "nrtIndexSizeStr", "nrtNumDocs"};
        static final String[] FIELD_DESCRIPTIONS = new String[]{"Path", "Index size in human readable format", "Index size in bytes", "Suggester size in human readable format", "Suggester size in bytes", "Number of documents in this index.", "The time and date for when the longest query took place", "Number of deleted documents", "NRT Index Size in bytes", "NRT Index Size in human readable format", "Number of documents in NRT index"};
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, SimpleType.LONG, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.LONG, SimpleType.STRING, SimpleType.INTEGER};
        static final CompositeType TYPE = IndexStats.createCompositeType();
        private final String path;
        private final long indexSize;
        private final int numDocs;
        private final int maxDoc;
        private final int numDeletedDocs;
        private final String indexSizeStr;
        private final long suggesterSize;
        private final String suggesterSizeStr;
        private final long nrtIndexSize;
        private final String nrtIndexSizeStr;
        private final int numDocsNRT;

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(IndexStats.class.getName(), "Composite data type for Lucene Index statistics", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public IndexStats(String path, IndexNode indexNode) throws IOException {
            this.path = path;
            this.numDocs = indexNode.getSearcher().getIndexReader().numDocs();
            this.maxDoc = indexNode.getSearcher().getIndexReader().maxDoc();
            this.numDeletedDocs = indexNode.getSearcher().getIndexReader().numDeletedDocs();
            this.indexSize = LuceneIndexMBeanImpl.getIndexSize(indexNode.getPrimaryReaders());
            this.indexSizeStr = IOUtils.humanReadableByteCount(this.indexSize);
            this.suggesterSize = DirectoryUtils.dirSize((Directory)indexNode.getSuggestDirectory());
            this.suggesterSizeStr = IOUtils.humanReadableByteCount(this.suggesterSize);
            this.nrtIndexSize = LuceneIndexMBeanImpl.getIndexSize(indexNode.getNRTReaders());
            this.numDocsNRT = LuceneIndexMBeanImpl.getNumDocs(indexNode.getNRTReaders());
            this.nrtIndexSizeStr = IOUtils.humanReadableByteCount(this.nrtIndexSize);
        }

        CompositeDataSupport toCompositeData() {
            Object[] values = new Object[]{this.path, this.indexSizeStr, this.indexSize, this.suggesterSizeStr, this.suggesterSize, this.numDocs, this.maxDoc, this.numDeletedDocs, this.nrtIndexSize, this.nrtIndexSizeStr, this.numDocsNRT};
            try {
                return new CompositeDataSupport(TYPE, FIELD_NAMES, values);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class LuceneDoc {
        final String path;
        final SearchContext sc;
        final int depth;

        public LuceneDoc(String path, SearchContext sc) {
            this.path = path;
            this.sc = sc;
            this.depth = PathUtils.getDepth(path);
        }

        public Iterable<LuceneDoc> getChildren() {
            BooleanQuery bq = new BooleanQuery();
            bq.add(new BooleanClause(new TermQuery(TermFactory.newAncestorTerm(this.path)), BooleanClause.Occur.MUST));
            bq.add(new BooleanClause(LuceneIndexMBeanImpl.newDepthQuery(this.path), BooleanClause.Occur.MUST));
            try {
                TopDocs docs = this.sc.searcher.search((Query)bq, Integer.MAX_VALUE);
                return LuceneIndexMBeanImpl.getLuceneDocs(docs, this.sc);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class SearchContext {
        final IndexSearcher searcher;

        SearchContext(IndexSearcher searcher) {
            this.searcher = searcher;
        }
    }
}

