/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.index.aggregate.AggregateIndex;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexAugmentorFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndex;
import org.apache.jackrabbit.oak.plugins.index.lucene.LucenePropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.lucene.score.ScorerProviderFactory;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class LuceneIndexProvider
implements QueryIndexProvider,
Observer,
Closeable {
    protected final IndexTracker tracker;
    protected volatile NodeAggregator aggregator = null;
    ScorerProviderFactory scorerFactory;
    IndexAugmentorFactory augmentorFactory;

    public LuceneIndexProvider() {
        this(new IndexTracker());
    }

    public LuceneIndexProvider(IndexCopier indexCopier) {
        this(new IndexTracker(indexCopier));
    }

    public LuceneIndexProvider(IndexTracker tracker) {
        this(tracker, ScorerProviderFactory.DEFAULT, null);
    }

    public LuceneIndexProvider(IndexTracker tracker, ScorerProviderFactory scorerFactory, IndexAugmentorFactory augmentorFactory) {
        this.tracker = tracker;
        this.scorerFactory = scorerFactory;
        this.augmentorFactory = augmentorFactory;
    }

    @Override
    public void close() {
        this.tracker.close();
    }

    @Override
    public void contentChanged(@Nonnull NodeState root, @Nonnull CommitInfo info) {
        this.tracker.update(root);
    }

    @Nonnull
    public List<QueryIndex> getQueryIndexes(NodeState nodeState) {
        return ImmutableList.of(new AggregateIndex(this.newLuceneIndex()), this.newLucenePropertyIndex());
    }

    protected LuceneIndex newLuceneIndex() {
        return new LuceneIndex(this.tracker, this.aggregator);
    }

    protected LucenePropertyIndex newLucenePropertyIndex() {
        return new LucenePropertyIndex(this.tracker, this.scorerFactory, this.augmentorFactory);
    }

    public void setAggregator(NodeAggregator aggregator) {
        this.aggregator = aggregator;
    }

    public LuceneIndexProvider with(NodeAggregator analyzer) {
        this.setAggregator(analyzer);
        return this;
    }

    IndexTracker getTracker() {
        return this.tracker;
    }
}

