/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionIndexProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionIndexProcessor.class);
    private String remaining;

    private FunctionIndexProcessor(String function) {
        this.remaining = function;
    }

    public static String[] getProperties(String[] functionCode) {
        ArrayList<String> properties = new ArrayList<String>();
        for (String token : functionCode) {
            if (!token.startsWith("@")) continue;
            String propertyName = token.substring(1);
            properties.add(propertyName);
        }
        return properties.toArray(new String[0]);
    }

    public static PropertyState tryCalculateValue(String path, NodeState state, String[] functionCode) {
        ArrayDeque<PropertyState> stack = new ArrayDeque<PropertyState>();
        for (int i = functionCode.length - 1; i > 0; --i) {
            PropertyState ps;
            String token = functionCode[i];
            if (token.startsWith("@")) {
                String propertyName = token.substring(1);
                ps = FunctionIndexProcessor.getProperty(path, state, propertyName);
            } else {
                ps = FunctionIndexProcessor.calculateFunction(token, stack);
            }
            if (ps == null) {
                return null;
            }
            stack.push(ps);
        }
        return (PropertyState)stack.pop();
    }

    public static String[] getFunctionCode(String functionDescription) {
        if (functionDescription == null) {
            return null;
        }
        return functionDescription.split("\\*");
    }

    private static PropertyState calculateFunction(String functionName, Deque<PropertyState> stack) {
        PropertyState result;
        PropertyState ps = stack.pop();
        Type<Object> type = null;
        ArrayList<String> values = new ArrayList<String>(ps.count());
        for (int i = 0; i < ps.count(); ++i) {
            Object x;
            String s = ps.getValue(Type.STRING, i);
            if ("lower".equals(functionName)) {
                x = s.toLowerCase();
                type = Type.STRING;
            } else if ("upper".equals(functionName)) {
                x = s.toUpperCase();
                type = Type.STRING;
            } else if ("length".equals(functionName)) {
                x = (long)s.length();
                type = Type.LONG;
            } else {
                LOG.debug("Unknown function {}", (Object)functionName);
                return null;
            }
            values.add((String)x);
        }
        if (values.size() == 1) {
            result = PropertyStates.createProperty("value", values.get(0), type);
        } else {
            type = type.getArrayType();
            result = PropertyStates.createProperty("value", values, type);
        }
        return result;
    }

    private static PropertyState getProperty(String path, NodeState state, String propertyName) {
        PropertyState ps;
        if (PathUtils.getDepth(propertyName) != 1) {
            for (String n : PathUtils.elements(PathUtils.getParentPath(propertyName))) {
                if ((state = state.getChildNode(n)).exists()) continue;
                return null;
            }
            propertyName = PathUtils.getName(propertyName);
        }
        if ((ps = ":localname".equals(propertyName) ? PropertyStates.createProperty("value", (Object)FunctionIndexProcessor.getLocalName(PathUtils.getName(path)), Type.STRING) : (":name".equals(propertyName) ? PropertyStates.createProperty("value", (Object)PathUtils.getName(path), Type.STRING) : state.getProperty(propertyName))) == null || ps.count() == 0) {
            return null;
        }
        return ps;
    }

    private static String getLocalName(String name) {
        int colon = name.indexOf(58);
        return colon < 0 ? name : name.substring(colon + 1);
    }

    public static String convertToPolishNotation(String function) {
        if (function == null) {
            return null;
        }
        FunctionIndexProcessor p = new FunctionIndexProcessor(function);
        return "function*" + p.parse();
    }

    String parse() {
        if (this.match("fn:local-name()") || this.match("localname()")) {
            return "@:localname";
        }
        if (this.match("fn:name()") || this.match("name()")) {
            return "@:name";
        }
        if (this.match("fn:upper-case(") || this.match("upper(")) {
            return "upper*" + this.parse() + this.read(")");
        }
        if (this.match("fn:lower-case(") || this.match("lower(")) {
            return "lower*" + this.parse() + this.read(")");
        }
        if (this.match("fn:string-length(") || this.match("length(")) {
            return "length*" + this.parse() + this.read(")");
        }
        int end = this.remaining.indexOf(41);
        if (end >= 0) {
            this.remaining = this.remaining.substring(0, end);
        }
        if (this.remaining.startsWith("[")) {
            return this.property(this.remaining.substring(1, this.remaining.lastIndexOf(93)).replaceAll("]]", "]"));
        }
        return this.property(this.remaining.replaceAll("@", ""));
    }

    String property(String p) {
        return "@" + p;
    }

    private String read(String string) {
        this.match(string);
        return "";
    }

    private boolean match(String string) {
        if (this.remaining.startsWith(string)) {
            this.remaining = this.remaining.substring(string.length());
            return true;
        }
        return false;
    }
}

