/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.NodeStateCopyUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.tree.TreeFactory;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public final class IndexDefinitionBuilder {
    private final NodeBuilder builder;
    private final Tree tree;
    private final Map<String, IndexRule> rules = Maps.newHashMap();
    private final Map<String, AggregateRule> aggRules = Maps.newHashMap();
    private final Tree indexRule;
    private final boolean autoManageReindexFlag;
    private Tree aggregatesTree;
    private final NodeState initial;
    private boolean reindexRequired;

    public IndexDefinitionBuilder() {
        this(EmptyNodeState.EMPTY_NODE.builder());
    }

    public IndexDefinitionBuilder(NodeBuilder nodeBuilder) {
        this(nodeBuilder, true);
    }

    public IndexDefinitionBuilder(NodeBuilder nodeBuilder, boolean autoManageReindexFlag) {
        this.autoManageReindexFlag = autoManageReindexFlag;
        this.builder = nodeBuilder;
        this.initial = nodeBuilder.getNodeState();
        this.tree = TreeFactory.createTree(this.builder);
        this.tree.setProperty("compatVersion", 2);
        this.tree.setProperty("async", "async");
        this.tree.setProperty("type", "lucene");
        this.tree.setProperty("jcr:primaryType", "oak:QueryIndexDefinition", Type.NAME);
        this.indexRule = IndexDefinitionBuilder.getOrCreateChild(this.tree, "indexRules");
    }

    public IndexDefinitionBuilder evaluatePathRestrictions() {
        this.tree.setProperty("evaluatePathRestrictions", true);
        return this;
    }

    public IndexDefinitionBuilder includedPaths(String ... paths) {
        this.tree.setProperty("includedPaths", Arrays.asList(paths), Type.STRINGS);
        return this;
    }

    public IndexDefinitionBuilder excludedPaths(String ... paths) {
        this.tree.setProperty("excludedPaths", Arrays.asList(paths), Type.STRINGS);
        return this;
    }

    public IndexDefinitionBuilder codec(String codecName) {
        this.tree.setProperty("codec", Preconditions.checkNotNull(codecName));
        return this;
    }

    public IndexDefinitionBuilder noAsync() {
        this.tree.removeProperty("async");
        return this;
    }

    public IndexDefinitionBuilder async(String ... asyncVals) {
        this.tree.removeProperty("async");
        this.tree.setProperty("async", Arrays.asList(asyncVals), Type.STRINGS);
        return this;
    }

    public Tree getBuilderTree() {
        return this.tree;
    }

    public NodeState build() {
        this.setReindexFlagIfRequired();
        return this.builder.getNodeState();
    }

    public Tree build(Tree tree) {
        NodeStateCopyUtils.copyToTree(this.build(), tree);
        return tree;
    }

    public Node build(Node node) throws RepositoryException {
        NodeStateCopyUtils.copyToNode(this.build(), node);
        return node;
    }

    public boolean isReindexRequired() {
        if (this.reindexRequired) {
            return true;
        }
        return !SelectiveEqualsDiff.equals(this.initial, this.builder.getNodeState());
    }

    private void setReindexFlagIfRequired() {
        if (!this.reindexRequired && !SelectiveEqualsDiff.equals(this.initial, this.builder.getNodeState()) && this.autoManageReindexFlag) {
            this.tree.setProperty("reindex", true);
            this.reindexRequired = true;
        }
    }

    public IndexRule indexRule(String type) {
        IndexRule rule = this.rules.get(type);
        if (rule == null) {
            rule = new IndexRule(IndexDefinitionBuilder.getOrCreateChild(this.indexRule, type), type);
            this.rules.put(type, rule);
        }
        return rule;
    }

    public boolean hasIndexRule(String type) {
        return this.indexRule.hasChild(type);
    }

    public AggregateRule aggregateRule(String type) {
        AggregateRule rule;
        if (this.aggregatesTree == null) {
            this.aggregatesTree = IndexDefinitionBuilder.getOrCreateChild(this.tree, "aggregates");
        }
        if ((rule = this.aggRules.get(type)) == null) {
            rule = new AggregateRule(IndexDefinitionBuilder.getOrCreateChild(this.aggregatesTree, type));
            this.aggRules.put(type, rule);
        }
        return rule;
    }

    public AggregateRule aggregateRule(String primaryType, String ... includes) {
        AggregateRule rule = this.aggregateRule(primaryType);
        for (String include : includes) {
            rule.include(include);
        }
        return rule;
    }

    private static Tree getOrCreateChild(Tree tree, String name) {
        if (tree.hasChild(name)) {
            return tree.getChild(name);
        }
        Tree child = tree.addChild(name);
        child.setOrderableChildren(true);
        child.setProperty("jcr:primaryType", "nt:unstructured", Type.NAME);
        return child;
    }

    static String getSafePropName(String relativePropName) {
        String propName = PathUtils.getName(relativePropName);
        int indexOfColon = propName.indexOf(58);
        if (indexOfColon > 0) {
            propName = propName.substring(indexOfColon + 1);
        }
        propName = propName.replaceAll("\\W", "");
        return propName;
    }

    static class SelectiveEqualsDiff
    extends EqualsDiff {
        SelectiveEqualsDiff() {
        }

        public static boolean equals(NodeState before, NodeState after) {
            return before.exists() == after.exists() && after.compareAgainstBaseState(before, new SelectiveEqualsDiff());
        }

        @Override
        public boolean propertyChanged(PropertyState before, PropertyState after) {
            if ("async".equals(before.getName())) {
                Set<String> asyncBefore = this.getAsyncValuesWithoutNRT(before);
                Set<String> asyncAfter = this.getAsyncValuesWithoutNRT(after);
                return asyncBefore.equals(asyncAfter);
            }
            return false;
        }

        private Set<String> getAsyncValuesWithoutNRT(PropertyState state) {
            HashSet<String> async = Sets.newHashSet(state.getValue(Type.STRINGS));
            async.remove("nrt");
            async.remove("sync");
            return async;
        }
    }

    public static class AggregateRule {
        private final Tree aggregate;
        private final Map<String, Include> includes = Maps.newHashMap();

        private AggregateRule(Tree aggregate) {
            this.aggregate = aggregate;
            this.loadExisting(aggregate);
        }

        public Include include(String includePath) {
            Include include = this.includes.get(includePath);
            if (include == null) {
                Tree includeTree = this.findExisting(includePath);
                if (includeTree == null) {
                    includeTree = IndexDefinitionBuilder.getOrCreateChild(this.aggregate, "include" + this.includes.size());
                }
                include = new Include(this, includeTree);
                this.includes.put(includePath, include);
            }
            include.path(includePath);
            return include;
        }

        private Tree findExisting(String includePath) {
            for (Tree tree : this.aggregate.getChildren()) {
                if (!includePath.equals(tree.getProperty("path").getValue(Type.STRING))) continue;
                return tree;
            }
            return null;
        }

        private void loadExisting(Tree aggregate) {
            for (Tree tree : aggregate.getChildren()) {
                if (!tree.hasProperty("path")) continue;
                Include include = new Include(this, tree);
                this.includes.put(include.getPath(), include);
            }
        }

        public static class Include {
            private final AggregateRule aggregateRule;
            private final Tree include;

            private Include(AggregateRule aggregateRule, Tree include) {
                this.aggregateRule = aggregateRule;
                this.include = include;
            }

            public Include path(String includePath) {
                this.include.setProperty("path", includePath);
                return this;
            }

            public Include relativeNode() {
                this.include.setProperty("relativeNode", true);
                return this;
            }

            public Include include(String path) {
                return this.aggregateRule.include(path);
            }

            public String getPath() {
                return this.include.getProperty("path").getValue(Type.STRING);
            }
        }
    }

    public static class PropertyRule {
        private final IndexRule indexRule;
        private final Tree propTree;

        private PropertyRule(IndexRule indexRule, Tree propTree, String name, boolean regex) {
            this.indexRule = indexRule;
            this.propTree = propTree;
            propTree.setProperty("name", name);
            if (regex) {
                propTree.setProperty("isRegexp", true);
            }
        }

        public PropertyRule useInExcerpt() {
            this.propTree.setProperty("useInExcerpt", true);
            return this;
        }

        public PropertyRule useInSpellcheck() {
            this.propTree.setProperty("useInSpellcheck", true);
            return this;
        }

        public PropertyRule type(String type) {
            PropertyType.valueFromName((String)type);
            this.propTree.setProperty("type", type);
            return this;
        }

        public PropertyRule useInSuggest() {
            this.propTree.setProperty("useInSuggest", true);
            return this;
        }

        public PropertyRule analyzed() {
            this.propTree.setProperty("analyzed", true);
            return this;
        }

        public PropertyRule nodeScopeIndex() {
            this.propTree.setProperty("nodeScopeIndex", true);
            return this;
        }

        public PropertyRule ordered() {
            this.propTree.setProperty("ordered", true);
            return this;
        }

        public PropertyRule ordered(String type) {
            this.type(type);
            this.propTree.setProperty("ordered", true);
            return this;
        }

        public PropertyRule disable() {
            this.propTree.setProperty("index", false);
            return this;
        }

        public PropertyRule propertyIndex() {
            this.propTree.setProperty("propertyIndex", true);
            return this;
        }

        public PropertyRule nullCheckEnabled() {
            this.propTree.setProperty("nullCheckEnabled", true);
            return this;
        }

        public PropertyRule notNullCheckEnabled() {
            this.propTree.setProperty("notNullCheckEnabled", true);
            return this;
        }

        public IndexRule enclosingRule() {
            return this.indexRule;
        }

        public Tree getBuilderTree() {
            return this.propTree;
        }

        public PropertyRule property(String name) {
            return this.indexRule.property(name, false);
        }

        public PropertyRule property(String name, boolean regex) {
            return this.indexRule.property(null, name, regex);
        }

        public PropertyRule property(String propDefnNodeName, String name) {
            return this.indexRule.property(propDefnNodeName, name, false);
        }
    }

    public static class IndexRule {
        private final Tree indexRule;
        private final Tree propsTree;
        private final String ruleName;
        private final Map<String, PropertyRule> props = Maps.newHashMap();
        private final Set<String> propNodeNames = Sets.newHashSet();

        private IndexRule(Tree indexRule, String type) {
            this.indexRule = indexRule;
            this.propsTree = IndexDefinitionBuilder.getOrCreateChild(indexRule, "properties");
            this.ruleName = type;
            this.loadExisting();
        }

        public IndexRule indexNodeName() {
            this.indexRule.setProperty("indexNodeName", true);
            return this;
        }

        public IndexRule includePropertyTypes(String ... types) {
            this.indexRule.setProperty("includePropertyTypes", Arrays.asList(types), Type.STRINGS);
            return this;
        }

        public PropertyRule property(String name) {
            return this.property(name, false);
        }

        public PropertyRule property(String name, boolean regex) {
            return this.property(null, name, regex);
        }

        public PropertyRule property(String propDefnNodeName, String name) {
            return this.property(propDefnNodeName, name, false);
        }

        public PropertyRule property(String propDefnNodeName, String name, boolean regex) {
            PropertyRule propRule = this.props.get(name);
            if (propRule == null) {
                Tree propTree = this.findExisting(name);
                if (propTree == null) {
                    if (propDefnNodeName == null) {
                        propDefnNodeName = this.createPropNodeName(name, regex);
                    }
                    propTree = IndexDefinitionBuilder.getOrCreateChild(this.propsTree, propDefnNodeName);
                }
                propRule = new PropertyRule(this, propTree, name, regex);
                this.props.put(name, propRule);
            }
            return propRule;
        }

        private void loadExisting() {
            for (Tree tree : this.propsTree.getChildren()) {
                if (!tree.hasProperty("name")) continue;
                String name = tree.getProperty("name").getValue(Type.STRING);
                boolean regex = false;
                if (tree.hasProperty("isRegexp")) {
                    regex = tree.getProperty("isRegexp").getValue(Type.BOOLEAN);
                }
                PropertyRule pr = new PropertyRule(this, tree, name, regex);
                this.props.put(name, pr);
            }
        }

        private Tree findExisting(String name) {
            for (Tree tree : this.propsTree.getChildren()) {
                if (!name.equals(tree.getProperty("name").getValue(Type.STRING))) continue;
                return tree;
            }
            return null;
        }

        private String createPropNodeName(String name, boolean regex) {
            String string = name = regex ? "prop" : IndexDefinitionBuilder.getSafePropName(name);
            if (name.isEmpty()) {
                name = "prop";
            }
            if (this.propNodeNames.contains(name)) {
                name = name + "_" + this.propNodeNames.size();
            }
            this.propNodeNames.add(name);
            return name;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public boolean hasPropertyRule(String propName) {
            return this.findExisting(propName) != null;
        }
    }
}

