/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.CRTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.spell.LuceneDictionary;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestHelper {
    private static final Logger log = LoggerFactory.getLogger(SuggestHelper.class);
    private static final Analyzer analyzer = new Analyzer(){

        @Override
        protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
            return new Analyzer.TokenStreamComponents(new CRTokenizer(Version.LUCENE_47, reader));
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSuggester(Directory directory, Analyzer analyzer, IndexReader reader) throws IOException {
        File tempDir = null;
        try {
            tempDir = Files.createTempDir();
            File tempSubChild = new File(tempDir, "non-existing-sub-child");
            if (reader.getDocCount(":suggest") > 0) {
                LuceneDictionary dictionary = new LuceneDictionary(reader, ":suggest");
                SuggestHelper.getLookup(directory, analyzer, tempSubChild).build(dictionary);
            }
        }
        catch (RuntimeException e) {
            log.debug("could not update the suggester", (Throwable)e);
        }
        finally {
            if (tempDir != null && !FileUtils.deleteQuietly((File)tempDir)) {
                log.error("Cleanup failed for temp dir {}", (Object)tempDir.getAbsolutePath());
            }
        }
    }

    public static List<Lookup.LookupResult> getSuggestions(AnalyzingInfixSuggester suggester, @Nullable SuggestQuery suggestQuery) {
        try {
            if (suggester != null && suggester.getCount() > 0L) {
                return suggester.lookup(suggestQuery.getText(), 10, true, false);
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeException("could not handle Suggest query " + suggestQuery, e);
        }
    }

    public static SuggestQuery getSuggestQuery(String suggestQueryString) {
        try {
            String text = null;
            for (String param : suggestQueryString.split("&")) {
                String[] keyValuePair = param.split("=");
                if (keyValuePair.length != 2 || keyValuePair[0] == null || keyValuePair[1] == null) {
                    throw new RuntimeException("Unparsable native Lucene Suggest query: " + suggestQueryString);
                }
                if (!"term".equals(keyValuePair[0])) continue;
                text = keyValuePair[1];
            }
            if (text != null) {
                return new SuggestQuery(text);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("could not build SuggestQuery " + suggestQueryString, e);
        }
    }

    public static AnalyzingInfixSuggester getLookup(Directory suggestDirectory) throws IOException {
        return SuggestHelper.getLookup(suggestDirectory, analyzer);
    }

    public static AnalyzingInfixSuggester getLookup(Directory suggestDirectory, Analyzer analyzer) throws IOException {
        return SuggestHelper.getLookup(suggestDirectory, analyzer, null);
    }

    public static AnalyzingInfixSuggester getLookup(final Directory suggestDirectory, Analyzer analyzer, final File tempDir) throws IOException {
        return new AnalyzingInfixSuggester(Version.LUCENE_47, tempDir, analyzer, analyzer, 3){

            @Override
            protected Directory getDirectory(File path) throws IOException {
                if (tempDir == null || tempDir.getAbsolutePath().equals(path.getAbsolutePath())) {
                    return suggestDirectory;
                }
                return FSDirectory.open(path);
            }
        };
    }

    public static Analyzer getAnalyzer() {
        return analyzer;
    }

    public static class SuggestQuery {
        private final String text;

        public SuggestQuery(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "SuggestQuery{text='" + this.text + '\'' + '}';
        }
    }
}

