/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndex;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;

@Component
@Service(value={QueryIndexProvider.class})
public class PropertyIndexProvider
implements QueryIndexProvider {
    @Reference
    private MountInfoProvider mountInfoProvider = Mounts.defaultMountInfoProvider();

    @Nonnull
    public List<QueryIndex> getQueryIndexes(NodeState state) {
        return ImmutableList.of(new PropertyIndex(this.mountInfoProvider));
    }

    public PropertyIndexProvider with(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
        return this;
    }

    protected void bindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    protected void unbindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        if (this.mountInfoProvider == mountInfoProvider) {
            this.mountInfoProvider = null;
        }
    }
}

