/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.plugins.observation.Filter;
import org.apache.jackrabbit.oak.plugins.observation.FilteringAwareObserver;
import org.apache.jackrabbit.oak.plugins.observation.FilteringDispatcher;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class FilteringObserver
implements Observer,
Closeable {
    static final CommitInfo NOOP_CHANGE = new CommitInfo("oak:unknown", "oak:unknown");
    private final BackgroundObserver backgroundObserver;
    private final Filter filter;
    private NodeState lastNoop;

    public FilteringObserver(@Nonnull Executor executor, int queueLength, @Nonnull Filter filter, @Nonnull FilteringAwareObserver observer) {
        this(new BackgroundObserver(new FilteringDispatcher(Preconditions.checkNotNull(observer)), Preconditions.checkNotNull(executor), queueLength), filter);
    }

    public FilteringObserver(@Nonnull BackgroundObserver backgroundObserver, @Nonnull Filter filter) {
        this.backgroundObserver = backgroundObserver;
        this.filter = Preconditions.checkNotNull(filter);
    }

    public BackgroundObserver getBackgroundObserver() {
        return this.backgroundObserver;
    }

    @Override
    public final void contentChanged(@Nonnull NodeState root, @Nonnull CommitInfo info) {
        if (this.filter.excludes(root, info)) {
            this.lastNoop = root;
            return;
        }
        if (this.lastNoop != null) {
            this.backgroundObserver.contentChanged(this.lastNoop, NOOP_CHANGE);
            this.lastNoop = null;
        }
        this.backgroundObserver.contentChanged(root, info);
    }

    @Override
    public void close() {
        this.backgroundObserver.close();
    }
}

