/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.GlobalNameMapper;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.namepath.NamePathMapperImpl;
import org.apache.jackrabbit.oak.plugins.observation.DefaultEventHandler;
import org.apache.jackrabbit.oak.plugins.observation.EventGenerator;
import org.apache.jackrabbit.oak.plugins.observation.EventHandler;
import org.apache.jackrabbit.oak.plugins.observation.FilteredHandler;
import org.apache.jackrabbit.oak.plugins.observation.filter.VisibleFilter;
import org.apache.jackrabbit.oak.plugins.tree.RootFactory;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeObserver
implements Observer {
    private static final PerfLogger PERF_LOGGER = new PerfLogger(LoggerFactory.getLogger((String)(NodeObserver.class.getName() + ".perf")));
    private static final Logger LOG = LoggerFactory.getLogger(NodeObserver.class);
    private final String path;
    private final Set<String> propertyNames = Sets.newHashSet();
    private NodeState previousRoot;

    protected NodeObserver(String path, String ... propertyNames) {
        this.path = path;
        Collections.addAll(this.propertyNames, propertyNames);
    }

    protected abstract void added(@Nonnull String var1, @Nonnull Set<String> var2, @Nonnull Set<String> var3, @Nonnull Set<String> var4, @Nonnull Map<String, String> var5, @Nonnull CommitInfo var6);

    protected abstract void deleted(@Nonnull String var1, @Nonnull Set<String> var2, @Nonnull Set<String> var3, @Nonnull Set<String> var4, @Nonnull Map<String, String> var5, @Nonnull CommitInfo var6);

    protected abstract void changed(@Nonnull String var1, @Nonnull Set<String> var2, @Nonnull Set<String> var3, @Nonnull Set<String> var4, @Nonnull Map<String, String> var5, @Nonnull CommitInfo var6);

    @Override
    public void contentChanged(@Nonnull NodeState root, @Nonnull CommitInfo info) {
        if (this.previousRoot != null) {
            try {
                long start = PERF_LOGGER.start();
                NamePathMapperImpl namePathMapper = new NamePathMapperImpl(new GlobalNameMapper(RootFactory.createReadOnlyRoot(root)));
                HashSet<String> oakPropertyNames = Sets.newHashSet();
                for (String name : this.propertyNames) {
                    String oakName = namePathMapper.getOakNameOrNull(name);
                    if (oakName == null) {
                        LOG.warn("Ignoring invalid property name: {}", (Object)name);
                        continue;
                    }
                    oakPropertyNames.add(oakName);
                }
                NodeState before = this.previousRoot;
                NodeState after = root;
                EventHandler handler = new FilteredHandler(VisibleFilter.VISIBLE_FILTER, new NodeEventHandler("/", info, namePathMapper, oakPropertyNames));
                String oakPath = namePathMapper.getOakPath(this.path);
                if (oakPath == null) {
                    LOG.warn("Cannot listen for changes on invalid path: {}", (Object)this.path);
                    return;
                }
                for (String oakName : PathUtils.elements(oakPath)) {
                    before = before.getChildNode(oakName);
                    after = after.getChildNode(oakName);
                    handler = handler.getChildHandler(oakName, before, after);
                }
                EventGenerator generator = new EventGenerator(before, after, handler);
                while (!generator.isDone()) {
                    generator.generate();
                }
                PERF_LOGGER.end(start, 100L, "Generated events (before: {}, after: {})", (Object)this.previousRoot, (Object)root);
            }
            catch (Exception e) {
                LOG.warn("Error while dispatching observation events", (Throwable)e);
            }
        }
        this.previousRoot = root;
    }

    private class NodeEventHandler
    extends DefaultEventHandler {
        private final String path;
        private final CommitInfo commitInfo;
        private final NamePathMapper namePathMapper;
        private final Set<String> propertyNames;
        private final EventType eventType;
        private final Set<String> added = Sets.newHashSet();
        private final Set<String> deleted = Sets.newHashSet();
        private final Set<String> changed = Sets.newHashSet();

        public NodeEventHandler(String path, CommitInfo commitInfo, NamePathMapper namePathMapper, Set<String> propertyNames) {
            this.path = path;
            this.commitInfo = commitInfo;
            this.namePathMapper = namePathMapper;
            this.propertyNames = propertyNames;
            this.eventType = EventType.CHANGED;
        }

        private NodeEventHandler(NodeEventHandler parent, String name, EventType eventType) {
            this.path = "/".equals(parent.path) ? '/' + name : parent.path + '/' + name;
            this.commitInfo = parent.commitInfo;
            this.namePathMapper = parent.namePathMapper;
            this.propertyNames = parent.propertyNames;
            this.eventType = eventType;
        }

        @Override
        public void leave(NodeState before, NodeState after) {
            switch (this.eventType) {
                case ADDED: {
                    NodeObserver.this.added(this.namePathMapper.getJcrPath(this.path), this.added, this.deleted, this.changed, this.collectProperties(after), this.commitInfo);
                    break;
                }
                case DELETED: {
                    NodeObserver.this.deleted(this.namePathMapper.getJcrPath(this.path), this.added, this.deleted, this.changed, this.collectProperties(before), this.commitInfo);
                    break;
                }
                case CHANGED: {
                    if (this.added.isEmpty() && this.deleted.isEmpty() && this.changed.isEmpty()) break;
                    NodeObserver.this.changed(this.namePathMapper.getJcrPath(this.path), this.added, this.deleted, this.changed, this.collectProperties(after), this.commitInfo);
                }
            }
        }

        private Map<String, String> collectProperties(NodeState node) {
            HashMap<String, String> properties = Maps.newHashMap();
            for (String name : this.propertyNames) {
                PropertyState p = node.getProperty(name);
                if (p == null || p.isArray()) continue;
                properties.put(name, p.getValue(Type.STRING));
            }
            return properties;
        }

        @Override
        public EventHandler getChildHandler(String name, NodeState before, NodeState after) {
            if (!before.exists()) {
                return new NodeEventHandler(this, name, EventType.ADDED);
            }
            if (!after.exists()) {
                return new NodeEventHandler(this, name, EventType.DELETED);
            }
            return new NodeEventHandler(this, name, EventType.CHANGED);
        }

        @Override
        public void propertyAdded(PropertyState after) {
            this.added.add(this.namePathMapper.getJcrName(after.getName()));
        }

        @Override
        public void propertyChanged(PropertyState before, PropertyState after) {
            this.changed.add(this.namePathMapper.getJcrName(after.getName()));
        }

        @Override
        public void propertyDeleted(PropertyState before) {
            this.deleted.add(this.namePathMapper.getJcrName(before.getName()));
        }
    }

    private static enum EventType {
        ADDED,
        DELETED,
        CHANGED;

    }
}

