/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tree;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.core.ImmutableRoot;
import org.apache.jackrabbit.oak.core.SystemRoot;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.query.CompositeQueryIndexProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.security.OpenSecurityProvider;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public final class RootFactory {
    private RootFactory() {
    }

    @Nonnull
    public static Root createReadOnlyRoot(@Nonnull NodeState rootState) {
        return new ImmutableRoot(rootState);
    }

    @Nonnull
    public static Root createReadOnlyRoot(@Nonnull Root root) {
        return ImmutableRoot.getInstance((Root)root);
    }

    @Nonnull
    public static Root createSystemRoot(@Nonnull NodeStore store, @Nullable CommitHook hook, @Nullable String workspaceName, @Nullable SecurityProvider securityProvider, @Nullable QueryEngineSettings queryEngineSettings, @Nullable QueryIndexProvider indexProvider) {
        return new SystemRoot(store, hook == null ? EmptyHook.INSTANCE : hook, workspaceName == null ? "default" : workspaceName, securityProvider == null ? new OpenSecurityProvider() : securityProvider, queryEngineSettings == null ? new QueryEngineSettings() : queryEngineSettings, indexProvider == null ? new CompositeQueryIndexProvider(new QueryIndexProvider[0]) : indexProvider);
    }
}

